(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     86064,       2583]*)
(*NotebookOutlinePosition[     87630,       2627]*)
(*  CellTagsIndexPosition[     87586,       2623]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Introducci\[OAcute]n a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Lo que sigue es bastante extenso y no es preciso que, en una primera lectura, \
lo leas todo con detalle. En particular, la secci\[OAcute]n dedicada a las \
funciones elementales y la secci\[OAcute]n dedicada a listas contienen muchos \
comandos que ir\[AAcute]s aprendiendo conforme los vayas necesitando. \
Intentar memorizarlos ahora no ser\[IAcute]a buena idea. Es suficiente con \
que sepas de su existencia y compruebes su uso con los ejemplos puestos. Las \
cosas que s\[IAcute] debes aprender son las siguientes.\
\>", "Text"],

Cell[TextData[{
  "Crear y evaluar celdas de ",
  StyleBox["input",
    FontSlant->"Italic"],
  " y de texto. Seleccionar celdas.\nConsultar la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\nRealizar operaciones aritm\[EAcute]ticas y entender bien su orden de \
prelaci\[OAcute]n.\nDistinguir entre valores exactos, es decir, valores simb\
\[OAcute]licos como \[DoubledPi] o ",
  Cell[BoxData[
      \(TraditionalForm\`\@5\)]],
  " y valores aproximados como 3.1416 o 2.236.\nDistinguir entre calcular de \
forma exacta (c\[AAcute]lculo simb\[OAcute]lico ) y calcular de forma \
aproximada (c\[AAcute]lculo num\[EAcute]rico).\nSaber usar los principales \
operadores boleanos. \nDistinguir entre variables y constantes.\nUsar el \
comando Clear[ ] con sus opciones apropiadadas en cada caso.\nDistinguir \
entre el comando de asignaci\[OAcute]n y el comando de asignaci\[OAcute]n \
diferida.\nDefinir funciones. Evaluar correctamente una funci\[OAcute]n.\nLos \
nombres de las funciones elementales m\[AAcute]s usuales en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\nGenerar listas con Table[ ] o Range[ ]. \nSeleccionar elementos en una \
lista. Comando Select[ ].\nEvaluar una funci\[OAcute]n en los elementos de \
una lista. El comando Map[ ].\nSumar y multiplicar listas y sumar y \
multiplicar los elementos de una lista. Comandos Plus[ ], Times[ ], Sum[ ], \
Product[ ].\nDefinir reglas de sustituci\[OAcute]n y usar el operador de \
sustituci\[OAcute]n."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "El entorno de trabajo. Distintos tipos de celdas. Evaluaci\[OAcute]n de \
celdas de ",
  StyleBox["input",
    FontSlant->"Italic"]
}], "Section"],

Cell[TextData[{
  "Acabas de abrir un cuaderno (notebook) de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[". Arriba tienes la barra de men\[UAcute] y a la derecha tienes \
una \"paleta\" cuya utilidad ir\[AAcute]s aprendiendo en lo que sigue. Lo \
primero que vas a hacer es maximizar esta ventana para que puedas leer mejor \
(la paleta se queda escondida detr\[AAcute]s de ella). Observa que este \
cuaderno est\[AAcute] estructurado en ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["celdas",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[". A la derecha de cada celda ver\[AAcute]s uno o varios \
corchetes. El m\[AAcute]s interior de ellos delimita la celda en cuesti\
\[OAcute]n. ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" suele agrupar las celdas en varias categor\[IAcute]as como, por \
ejemplo, pertenecer a la misma secci\[OAcute]n o a la misma \
subsecci\[OAcute]n; y es eso precisamente lo que reflejan los corchetes \
externos. Hay celdas de distintos tipos. Esta que est\[AAcute]s leyendo es \
una celda de texto y si te fijas bien el corchete que la delimita tiene una \
doble barrita arriba. Para escribir en un cuaderno de ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" primero ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["tienes que crear una nueva celda",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" lo que se hace como sigue: situa el rat\[OAcute]n fuera de una \
celda, por ejemplo, en el peque\[NTilde]o espacio que hay entre dos celdas \
consecutivas y cuando el cursor se convierta en una barra horizontal haz clic \
con el bot\[OAcute]n izquierdo del rat\[OAcute]n y aparecer\[AAcute] una l\
\[IAcute]nea horizontal; seguidamente escribe lo que quieras. Cuando acabes \
de escribir se habr\[AAcute] creado una nueva celda cuyo contenido ser\
\[AAcute] lo que t\[UAcute] has escrito. Escribe ahora tu nombre debajo de \
esta celda.",
    FontVariations->{"CompatibilityType"->0}]
}], "Text"],

Cell[TextData[{
  "Como no le has dicho a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que solamente quer\[IAcute]as escribir texto el programa ha creado una \
nueva ",
  StyleBox["celda de entrada",
    FontSlant->"Italic"],
  " (input cell). Observa que, con el estilo que estamos usando en este \
cuaderno, las celdas de entrada tienen un aspecto muy diferente de las celdas \
de texto. Pon el rat\[OAcute]n sobre el corchete interior de la celda que has \
creado con tu nombre y cuando el cursor se convierta en una flecha haz clic \
con el bot\[OAcute]n izquierdo del rat\[OAcute]n. As\[IAcute] es como se \
seleccionan celdas. Ahora, mientras la celda est\[AAcute] seleccionada, pulsa \
Alt+7 para convertirla en una celda de texto (alternativamente, en la barra \
de men\[UAcute] Cell\[Rule]Display As\[Rule]Text). \nLas ",
  StyleBox["celdas de input",
    FontSlant->"Italic"],
  " son las que se crean por defecto y sirven para introducir datos y \
funciones y podemos pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que las ejecute y realice los c\[AAcute]lculos indicados. Para ejecutar \
una celda de",
  StyleBox[" input",
    FontSlant->"Italic"],
  " debes hacer clik con el bot\[OAcute]n izquierdo del rat\[OAcute]n en alg\
\[UAcute]n lugar dentro de la celda. Ver\[AAcute]s un cursor vertical que \
aparece y desaparece. Ahora pulsa la tecla \"Intro\" del teclado \
num\[EAcute]rico o bien pulsa \"may\[UAcute]sculas\" + \"Return\" y comprobar\
\[AAcute]s que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ejecuta la celda y te da la respuesta correspondiente en una ",
  StyleBox["celda de salida",
    FontSlant->"Italic"],
  ". Ejecuta la siguiente celda."
}], "Text"],

Cell[BoxData[
    \(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\( Sin[x]\/x\) 
        \[DifferentialD]x\)], "Input"],

Cell[TextData[{
  "Observa que el programa ha escrito In[1] y Out[1] para referirse a la \
entrada y salida correspondientes. De esta forma ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lleva un control de todo lo que vas haciendo lo que te permite aprovechar \
los resultados obtenidos para otros c\[AAcute]lculos posteriores. \
F\[IAcute]jate en que el corchete que delimita una celda de entrada tiene un \
peque\[NTilde]o triangulito en la parte superior. En esta primera evaluaci\
\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha tenido que cargar el n\[UAcute]cleo (el ",
  StyleBox["kernel",
    FontSlant->"Italic"],
  "), es decir, las reglas e instrucciones internas de c\[AAcute]lculo del \
programa las cuales ya permanecer\[AAcute]n en la memoria hasta que lo \
cierres. Por eso esta primera evaluaci\[OAcute]n es algo m\[AAcute]s lenta de \
lo normal."
}], "Text"],

Cell[TextData[{
  "En una misma celda puedes escribir varias instrucciones en l\[IAcute]neas \
distintas (para pasar de una l\[IAcute]nea a otra se pulsa \"Return\")  y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interpreta cada una de ellas como una entrada diferente. La siguiente \
celda de input contiene dos entradas y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " producir\[AAcute] dos salidas, una para cada entrada."
}], "Text"],

Cell[BoxData[{
    \(Limit[\(x - Sin[x]\)\/x\^3, x \[Rule] 0]\), 
    \(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\(\( 1 - Cos[x]\)\/x\^2\) 
        \[DifferentialD]x\)}], "Input"],

Cell["\<\
Comprueba que si ahora ejecutas otra celda de entrada no se le asignar\
\[AAcute] In[3] sino In[4].\
\>", "Text"],

Cell[BoxData[
    \(Expand[\((1 + x + x\^2)\)\^7, x]\)], "Input"],

Cell[TextData[{
  "A veces no interesa que se muestre en pantalla el resultado de una \
entrada. Por ejemplo si le pides a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que genere una lista con todos los n\[UAcute]meros del 1 al 100 no te \
interesa para nada que se muestre el resultado en pantalla. Ejecuta la \
siguiente celda."
}], "Text"],

Cell[BoxData[
    \(Range[100]\)], "Input"],

Cell[TextData[{
  "Para evitar esto basta escribir \";\" al final de la entrada. De esta \
forma ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " hace y recuerda los c\[AAcute]culos pero no los muestra en pantalla."
}], "Text"],

Cell[BoxData[
    \(\(Range[200]; \)\)], "Input"],

Cell[TextData[{
  "Aparentemente ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no ha hecho nada. Pero eso no es as\[IAcute]. Para referirnos a una \
salida en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " podemos hacerlo invocando de forma expl\[IAcute]cita su identificaci\
\[OAcute]n; ",
  StyleBox["\"Out[p]\"",
    FontWeight->"Bold"],
  "se refiere a la salida n\[UAcute]mero \"",
  StyleBox["p",
    FontWeight->"Bold"],
  "\", y tambi\[EAcute]n con el s\[IAcute]mbolo \"",
  StyleBox["%",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["el cual se refiere siempre a la salida inmediata anterior",
    FontWeight->"Bold"],
  ", el s\[IAcute]mbolo \"",
  StyleBox["%%",
    FontWeight->"Bold"],
  "\" se refiere a ",
  StyleBox["la salida pen\[UAcute]ltima",
    FontWeight->"Bold"],
  ", \"",
  StyleBox["%%%",
    FontWeight->"Bold"],
  "\" a la salida antepen\[UAcute]ltima, etc\[EAcute]tera. Comprobemos que, \
efectivamente, la \[UAcute]ltima salida son los primeros doscientos \
n\[UAcute]meros."
}], "Text"],

Cell[BoxData[
    \(%\)], "Input"],

Cell[TextData[{
  "Para seleccionar una celda se pone el cursor sobre el corchete que la \
delimita y cuando el cursor se convierta en una flechita haces clic con el \
rat\[OAcute]n. Muchos errores e ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se deben a efectos derivados de \"copiar y pegar\". ",
  StyleBox["Para copiar en ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " NO se selecciona texto sino que se selecciona la celda entera se copia y \
se pega y, si es necesario, despu\[EAcute]s se borra lo que sobre.",
    FontWeight->"Bold"]
}], "Text"],

Cell["\<\
Antes de acabar esta primera secci\[OAcute]n, te propongo que selecciones con \
el rat\[OAcute]n el corchete exterior de la derecha y hagas doble clic. Ver\
\[AAcute]s c\[OAcute]mo las celdas de esta secci\[OAcute]n quedan todas \
agrupadas en una sola vi\[EAcute]ndose solamente el encabezado de la secci\
\[OAcute]n. Para abrirlas de nuevo selecciona el corchete con forma de flecha \
que las agrupa y haz doble clic en \[EAcute]l.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Abortar la evaluaci\[OAcute]n de una celda", "Section"],

Cell[TextData[{
  "A veces, al ejecutar una celda, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se queda \"colgada\". Cuando esto ocurre aparece una barrita amarilla a \
la derecha de la celda que se est\[AAcute] ejecutando y el programa no \
responde. Lo que hay que hacer es pulsar Alt+. (la tecla Alt y la tecla del \
signo de puntuaci\[OAcute]n \"punto\" a la vez). Si esto no sirve hay que ir \
a Kernel\[Rule]Evaluation\[Rule]Abort Evaluation. Si esto no funciona \
tampoco, entonces no hay m\[AAcute]s remedio que ir a Kernel\[Rule]Quit \
Kernel\[Rule]Local y cerrar el n\[UAcute]cleo con lo cual es como si ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " arrancara de nuevo. Al ejecutar la siguiente celda el programa se te va a \
colgar. Ya sabes lo que tienes que hacer \[DownExclamation]y hazlo prontito!"
}], "Text"],

Cell[BoxData[
    \(x //. {x -> x + a, a -> x}\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operaciones aritm\[EAcute]ticas", "Section"],

Cell[TextData[{
  "Puedes realizar operaciones aritm\[EAcute]ticas con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " igual que con una calculadora manual. Los s\[IAcute]mbolos para estas \
operaciones son los usuales  (\"+\", \"-\", \"*\", \"/\", y \"^\") y se \
realizan con la precedencia usual: la exponenciaci\[OAcute]n (\"^\") precede \
a la multiplicaci\[OAcute]n (\"*\") y a la divisi\[OAcute]n (\"/\") las \
cuales tienen igual precedencia y, a su vez, preceden a la suma y a la \
diferencia que tienen igual precedencia. En una expresi\[OAcute]n como \
\"6*7^5+26\" se calcula primero \"7^5\" seguido por \"6*7^5\" para terminar \
sumando \"26\"."
}], "Text"],

Cell[BoxData[
    \(6*7^5 + 26\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " permite que sustituyas el s\[IAcute]mbolo de la multiplicaci\[OAcute]n \
por un espacio en blanco."
}], "Text"],

Cell[BoxData[
    \(6\ 7^5 + 26\)], "Input"],

Cell["\<\
Ahora que est\[AAcute]s empezando es preferible que uses el s\[IAcute]mbolo \
de la multiplicaci\[OAcute]n para evitar posibles errores. \
\>", "Text"],

Cell[TextData[{
  "A diferencia de las calculadoras manuales m\[AAcute]s sencillas, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede trabajar con fracciones en forma simb\[OAcute]lica, es decir, sin \
convertirlas a su expresi\[OAcute]n decimal."
}], "Text"],

Cell[BoxData[
    \(7 + 9\/13\)], "Input"],

Cell[BoxData[
    \(8\/11 + 6\/7\)], "Input"],

Cell["\<\
Las fracciones se representan siempre en su forma irreducible.\
\>", "Text"],

Cell[BoxData[
    \(4032\/15015\)], "Input"],

Cell[TextData[{
  "Naturalmente, la potencia de c\[AAcute]lculo de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es muy superior a la de una calculadora manual."
}], "Text"],

Cell[BoxData[
    \(3^95\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Valores exactos y aproximados", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " hay dos clases de valores: exactos y aproximados. Valores exactos son los \
enteros, las fracciones y las representaciones simb\[OAcute]licas de \
constantes como \[Pi] o ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  ". De ellos ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe calcular tantos d\[IAcute]gitos como sea necesario en cualquier c\
\[AAcute]lculo. Los valores aproximados son los n\[UAcute]meros decimales, es \
decir, n\[UAcute]meros en cuya expresi\[OAcute]n aparece un punto decimal. "
}], "Text"],

Cell[TextData[{
  StyleBox["Debes tener siempre presente que ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " devuelve los resultados de la misma forma que introduces los datos, es \
decir, ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " nunca tratar\[AAcute] de convertir valores exactos en valores aproximados \
y si en un c\[AAcute]lculo intervienen valores exactos y aproximados el \
resultado ser\[AAcute] un valor aproximado.",
    FontWeight->"Bold"]
}], "Text"],

Cell[BoxData[
    \(4^\((1/2)\) + Log[\[ExponentialE]]\)], "Input"],

Cell[TextData[{
  "En este caso como la operaci\[OAcute]n puede realizarse de forma exacta, ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la hace y presenta el resultado exacto obtenido."
}], "Text"],

Cell[BoxData[
    \(3^\((1/2)\) + Log[5]\)], "Input"],

Cell[TextData[{
  "En este c\[AAcute]lculo como el resultado no es un n\[UAcute]mero exacto \
pero los datos s\[IAcute] lo son, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja de forma simb\[OAcute]lica, no realiza la operaci\[OAcute]n \
indicada y devuelve los mismos datos. Observa lo que ocurre si ahora \
cambiamos el valor exacto \"5\" por \"5.\" que es un n\[UAcute]mero con punto \
decimal y por tanto es considerado por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " como un valor aproximado."
}], "Text"],

Cell[BoxData[
    \(3^\((1/2)\) + Log[5. ]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " realiza las operaciones indicadas y el resultado tambi\[EAcute]n es un \
valor aproximado. Pobre resultado pensar\[AAcute]s: s\[OAcute]lo cinco \
decimales, cualquier calculadora manual es m\[AAcute]s precisa. No te \
precipites. Aunque ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "por defecto presenta en pantalla los valores aproximados con solamente ",
  StyleBox["seis d\[IAcute]gitos",
    FontSlant->"Italic"],
  " y a veces los redondea como hizo antes; los n\[UAcute]meros con punto \
decimal son guardados en la memoria interna de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con al menos 16 d\[IAcute]gitos significativos. "
}], "Text"],

Cell[TextData[{
  "Lo anterior te indica que ",
  StyleBox["es importante la forma en que introducimos los datos",
    FontWeight->"Bold"],
  ": no es lo mismo introducir 1/2 que .5. Tampoco es lo mismo 2. (un n\
\[UAcute]mero real aproximado para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") que 2 sin punto decimal (que es tratado como un n\[UAcute]mero entero). \
Como ya te he dicho antes, cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja con valores exactos lo hace de forma simb\[OAcute]lica y el \
resultado ser\[AAcute] tambi\[EAcute]n un valor exacto. "
}], "Text"],

Cell[TextData[{
  "Los valores exactos tienen precisi\[OAcute]n infinita y pueden convertirse \
en n\[UAcute]meros aproximados con la precisi\[OAcute]n que queramos. El \
comando \"",
  StyleBox["N[expr, n]",
    FontWeight->"Bold"],
  "\" donde \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" es un valor exacto eval\[UAcute]a \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" num\[EAcute]ricamente convirti\[EAcute]ndola en un n\[UAcute]mero \
aproximado con ",
  StyleBox["n",
    FontWeight->"Bold"],
  " d\[IAcute]gitos de precisi\[OAcute]n. La precicisi\[OAcute]n por defecto \
es de 16 d\[IAcute]gitos. "
}], "Text"],

Cell[BoxData[{
    \(Precision[\@2]\ \  (*
      Un\ n\[UAcute]mero\ exacto\ tiene\ precisi\[OAcute]n\ infinita*) \), 
    \(Precision[N[\@2, 30]]\  (*
      Podemos\ convertirlo\ en\ un\ n\[UAcute]mero\ de\ la\ precisi\[OAcute]n
        \ que\ queramos*) \ \), 
    \(N[\@2, 30]\  (*
      Mathematica\ muestra\ en\ pantalla\ el\ valor\ num\[EAcute]rico\ de\ 
        \@2\ con\ 30\ d\[IAcute]gitos*) \), 
    \(Precision[\@2. ]\  (*
      Un\ valor\ aproximado\ tiene\ precisi\[OAcute]n\ 16\ por\ defecto*) 
      \), 
    \(Precision[N[\@2. , 50]]\  (*
      No\ podemos\ aumentar\ su\ precisi\[OAcute]n*) \), 
    \(N[\@2. , 50]\  (*
      Mathematica\ muestra\ en\ pantalla\ 16\ d\[IAcute]gitos*) \), 
    \(N[\@2, 3]\  (*
      Mathematica\ muestra\ en\ pantalla\ el\ valor\ num\[EAcute]rico\ de\ 
        \@2\ con\ 3\ d\[IAcute]gitos\ pero\ lo\ almacena\ con\ 16*) \)}], 
  "Input"],

Cell[TextData[{
  "En la celda anterior hemos escrito varios ",
  StyleBox["comentarios",
    FontWeight->"Bold"],
  ". ",
  StyleBox[
  "Los comentarios son imprescindibles para explicar lo que hacen los \
comandos que defines al escribir un programa",
    FontWeight->"Bold"],
  ". Un comentario es de la forma \"(*aqu\[IAcute] se escribe el texto del \
comentario*)\" y son ignorados por el programa cuando se ejecutan las celdas \
que los contienen. "
}], "Text"],

Cell[TextData[{
  "Cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja con valores exactos, es decir, simb\[OAcute]licamente, se dice \
que lo hace con \"precisi\[OAcute]n infinita\". Ya puedes suponer que \
trabajar simb\[OAcute]licamente con valores exactos requiere m\[AAcute]s \
memoria y m\[AAcute]s tiempo de c\[AAcute]lculo que trabajar con valores \
aproximados, por eso ",
  StyleBox[
  "cuando escribas programas que deban realizar muchos c\[AAcute]lculos es \
muy importante que te asegures de que ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" trabajar\[AAcute] con valores aproximados",
    FontWeight->"Bold"],
  " (controlando, si es necesario, la precisi\[OAcute]n con la que trabaja)."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operaciones boleanas", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tienen algunas funciones que no devuelven un resultado num\[EAcute]rico \
sino un valor \"False\" o \"True\". Entre ellas se encuentran: \nA) \
Operadores relacionales de comparaci\[OAcute]n de dos expresiones aritm\
\[EAcute]ticas: menor (<), mayor (>), menor o igual (<=), mayor o igual (>=), \
igual (==) \[DownExclamation]con dos signos de igualdad!, distinto (!=). \nB) \
Operadores l\[OAcute]gicos que trabajan con valores \"False\" y \"True\" y \
devuelven como valor \"False\" o \"True\". Entre estos operadores \
est\[AAcute]n: el operador \"and\" (&&) (conjunci\[OAcute]n l\[OAcute]gica \
que devuelve \"True\" si los dos valores sobre los que act\[UAcute]a son \
\"True\" y devuelve \"False\" en otro caso), el oerador \"or\" ( | | ) \
(disyunci\[OAcute]n l\[OAcute]gica que devuelve \"True\" si algunos de los \
valores sobre los que act\[UAcute]a es \"True\" y devuelve \"False\" si ambos \
son \"False\").\nTecleando \"\[EscapeKey] <= \[EscapeKey]\" obtienes \
\[LessEqual], tecleando \"\[EscapeKey] >= \[EscapeKey]\" obtienes \
\[GreaterEqual], tecleando \"\[EscapeKey] && \[EscapeKey]\" obtienes \[And], \
tecleando \"\[EscapeKey] || \[EscapeKey]\" obtienes \[Or], tecleando \"\
\[EscapeKey] != \[EscapeKey]\" obtienes \[NotEqual].\nAqu\[IAcute] tienes \
algunos ejemplos."
}], "Text"],

Cell[BoxData[{
    \(5 > 5\), 
    \(8 \[GreaterEqual] 8\), 
    \(\((5 > 7)\) || \((3 < 4)\)\), 
    \(\((5 > 7)\) && \((3 > 4)\)\), 
    \(\@2 < 27/22\)}], "Input"],

Cell[TextData[{
  "Cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no puede dicidir una respuesta devuelve sin comentarios la misma expresi\
\[OAcute]n de entrada."
}], "Text"],

Cell[BoxData[
    \(\(x < 27\  (*
      como\ x\ no\ tiene\ asignado\ ning\[UAcute]n\ valor\ num\[EAcute]rico\ 
        Mathematica\ no\ puede\ hacer\ la\ comparaci\[OAcute]n\ que\ 
        pedimos*) \)\)], "Input"],

Cell[TextData[{
  "El operador de igualdad (==) puede utilizarse para comprobar si dos \
cantidades num\[EAcute]ricas \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" y \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" son \"iguales\". Si las cantidades son aproximadas el operador de \
igualdad (==) ",
  StyleBox["comprueba si ambas son iguales con la precisi\[OAcute]n de \
aquella que la tiene menor",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Tambi\[EAcute]n debes de tener en cuenta que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " asocia a cada n\[UAcute]mero aproximado ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " una cota de error \[Delta] (relacionada con el n\[UAcute]mero de cifras \
decimales de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " y con el valor absoluto de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ") y considera que el valor verdadero de dicho n\[UAcute]mero puede ser \
cualquier n\[UAcute]mero en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`x - \[Delta]/2, x + \[Delta]/2\)]],
  "[. Por ello ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " considera iguales a ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " todos los n\[UAcute]meros en dicho intervalo. Por esta raz\[OAcute]n el \
operador de igualdad puede proporcionar algunas veces respuestas extra\
\[NTilde]as. No es este el momento para entrar en detalles, solamente quiero \
llamarte la atenci\[OAcute]n para que seas prudente en el uso del operador de \
igualdad (==) cuando quieras usarlo para saber cu\[AAcute]ndo dos cantidades \
pueden ser consideradas iguales a efectos de c\[AAcute]lculo. Cuando el \
operador de igualdad \"",
  StyleBox["cantidad1==cantidad2\"",
    FontWeight->"Bold"],
  " proporciona la salida True, debes interpretar que dichas cantidades son \
iguales con una cierta cota de error. No es propio de la asignatura de An\
\[AAcute]lisis Matem\[AAcute]tico profundizar en estos temas. En otras \
asignaturas estudiar\[AAcute]s la aritm\[EAcute]tica de punto flotante, la \
forma en que se representan internamente los n\[UAcute]meros en un ordenador, \
la propagaci\[OAcute]n de errores de redondeo y otros temas afines y entonces \
entender\[AAcute]s estos comportamientos (que no son, por supuesto, espec\
\[IAcute]ficos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Aqu\[IAcute] tienes algunos ejemplos de lo que digo."
}], "Text"],

Cell[BoxData[{
    \(123456789012345.  == 123456789012344\  (*
      Mathematica\ considera\ que\ estos\ dos\ n\[UAcute]meros\ son\ 
        iguales . \ Observa\ que\ su\ diferencia\ es\ igual\ a\ 1\ *) \), 
    \(1.2345678901234 == 1.2345678901233\  (*
      Mathematica\ considera\ que\ estos\ dos\ n\[UAcute]meros\ son\ 
        distintos . \ Observa\ que\ su\ diferencia\ es\ igual\ a\ 
        10^\(-13\)\ \ *) \), 
    \(1.23456789012349 == 1.23456789012348 (*
      Mathematica\ considera\ que\ estos\ dos\ n\[UAcute]meros\ son\ 
        iguales . \ Observa\ que\ su\ diferencia\ es\ igual\ a\ 
        10^\(-14\)\ *) \), 
    \(1 == 
      1.  + 10^\(-14\)\ \  (*
            Aqu\[IAcute]\ trabajamos\ con\ precisi\[OAcute]n\ 16\ y\ 
              Mathematica\ considera\ que\ dichas\ cantidades\ son\ iguales
              \ *) \n1 == N[1 + 10^\(-14\), 17]\ \  (*
      Aqu\[IAcute]\ trabajamos\ con\ precisi\[OAcute]n\ 17\ y\ Mathematica\ 
        considera\ que\ dichas\ cantidades\ no\ son\ iguales\ *) \ \), 
    \(Pi == N[Pi, 2]\  (*
      Comprueba\ si\ son\ iguales\ consider\[AAcute]ndolos\ como\ 
        n\[UAcute]meros\ m\[AAcute]quina\ *) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Consultar la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section"],

Cell[TextData[{
  "Consultar la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es lo m\[AAcute]s f\[AAcute]cil que te puedas imaginar. Basta pulsar F1. \
Si antes has seleccionado con el rat\[OAcute]n la palabra que quieres \
consultar, la ayuda se abrir\[AAcute] justamente donde te interesa. \
Selecciona la palabra en la celda siguiente y pulsa F1. "
}], "Text"],

Cell["Integrate", "Text",
  TextAlignment->Center],

Cell["\<\
Tambi\[EAcute]n puedes consultar sobre un s\[IAcute]mbolo o un comando espec\
\[IAcute]ficos escribiendo uno o dos s\[IAcute]mbolos de \
interrogaci\[OAcute]n seguido del nombre del comando del que quieres \
informaci\[OAcute]n.Ejecuta la siguiente celda.\
\>", "Text"],

Cell[BoxData[
    \(\(?\ N\)\)], "Input"],

Cell["Si todav\[IAcute]a quieres m\[AAcute]s informaci\[OAcute]n hazlo como \
sigue.", "Text"],

Cell[BoxData[
    \(?? \ N\)], "Input"],

Cell[TextData[{
  StyleBox["Debes tener en cuenta que",
    FontWeight->"Bold"],
  " ",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["distingue entre may\[UAcute]sculas y min\[UAcute]sculas",
    FontWeight->"Bold"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Escribir expresiones matem\[AAcute]ticas en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section"],

Cell[TextData[{
  "Frecuentemente las expresiones matem\[AAcute]ticas se pueden escribir de \
varias formas que solamente se diferencian por su apariencia \
tipogr\[AAcute]fica. Puedes escribir 3^(1/7) o ",
  Cell[BoxData[
      \(TraditionalForm\`\@3\%7\)]],
  " a efectos de c\[AAcute]lculo son exactamente igual. Las paletas te ayudan \
a escribir con la apariencia que prefieras y son muy f\[AAcute]ciles de usar. \
En File\[Rule]Palettes encontrar\[AAcute]s varias paletas adem\[AAcute]s de \
la b\[AAcute]sica (BasicInput) que se abre al iniciar el programa. Tambi\
\[EAcute]n puedes consultar Edit\[Rule]Expression Input.Te indico a \
continuaci\[OAcute]n otra forma de escribir algunos s\[IAcute]mbolos de uso \
frecuente.\nPotencias: usa \"\[ControlKey]+6\". Por ejemplo: a \
\"\[ControlKey]+6\" b = ",
  Cell[BoxData[
      \(TraditionalForm\`a\^b\)]],
  " (para salir de la celda \"inline\" que se crea hay que pulsar \
\[ControlKey]+espacio) \nRa\[IAcute]ces: usa \"\[ControlKey]+2\". Por \
ejemplo: \"\[ControlKey]+2\" a = ",
  Cell[BoxData[
      \(TraditionalForm\`\@a\)]],
  " (para salir de la celda \"inline\" que se crea hay que pulsar \
\[ControlKey]+espacio) \nFracciones: usa \"\[ControlKey]+May\[UAcute]sculas+7\
\" para que aparezca una fracci\[OAcute]n en la que puedes escribir en el \
numerador y en el denominador. \nLetras griegas: usa \[EscapeKey]+letra \
latina equivalente+\[EscapeKey]. Por ejemplo: \[EscapeKey]+p+\[EscapeKey] = \
\[Pi].\nLa letra E est\[AAcute] reservada en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para el n\[UAcute]mero base de los logaritmos naturales. Puedes \
escribirlo tambi\[EAcute]n con \[EscapeKey]+ee+\[EscapeKey] = \
\[ExponentialE].\nEl n\[UAcute]mero \[Pi] puedes escribirlo tambi\[EAcute]n \
Pi. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Variables y constantes. El comando de asignaci\[OAcute]n (",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  ")"
}], "Section"],

Cell[TextData[{
  "Lo que realmente distingue a un programa como ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es su capacidad para trabajar simb\[OAcute]licamente; es decir, trabajar \
con expresiones algebraicas en las que intervienen s\[IAcute]mbolos que no \
tienen un valor num\[EAcute]rico concreto. Solemos referirnos a estos s\
\[IAcute]mbolos como ",
  StyleBox["variables",
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[BoxData[{
    \(a^\((1/2)\) a^\((1/3)\)\), 
    \(a\  + \ 3  b\  + \ c^2\  + 4\ a\  + \ 3\ c^2\), 
    \(Exp[x] Exp[y]\)}], "Input"],

Cell[TextData[{
  "Para multiplicar n\[UAcute]meros por variables no es preciso dejar un \
espacio en blanco. Para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " pr\[AAcute]cticamente cualquier letra o combinaci\[OAcute]n de letras \
puede ser una variable. Hay excepciones que corresponden a algunos \
s\[IAcute]mbolos protegidos como los de las operaciones aritm\[EAcute]ticas o \
como la letra E, que siempre indica el n\[UAcute]mero \[ExponentialE] base de \
los logaritmos naturales. Sin embargo, todas las letras min\[UAcute]sculas \
{x, y, z... a, b, c, d...} y sus combinaciones pueden usarse sin problemas \
para representar variables. No olvides que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distingue entre may\[UAcute]sculas y min\[UAcute]sculas. "
}], "Text"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " el s\[IAcute]mbolo de igualdad (=) es la forma usual de escribir el \
comando \"",
  StyleBox["Set[ ]",
    FontWeight->"Bold"],
  "\" (l\[EAcute]ase ",
  StyleBox["atribuye",
    FontSlant->"Italic"],
  " o ",
  StyleBox["asigna",
    FontSlant->"Italic"],
  "). As\[IAcute] \"",
  StyleBox["expr1=expr2",
    FontWeight->"Bold"],
  "\" y \"",
  StyleBox["Set[expr1,expr2]",
    FontWeight->"Bold"],
  "\" son dos formas de decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que eval\[UAcute]e ",
  StyleBox["inmediatamente",
    FontSlant->"Italic"],
  " ",
  StyleBox["expr2",
    FontWeight->"Bold"],
  " y el resultado de esta operaci\[OAcute]n lo asigne en adelante al s\
\[IAcute]mbolo ",
  StyleBox["expr1",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "interpreta que una expresi\[OAcute]n \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" formada por una letra o una combinaci\[OAcute]n de letras es una \
variable si no se le ha asignado ning\[UAcute]n valor concreto; cuando a \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" se le asigna un valor concreto, el programa reemplazar\[AAcute] cada \
aparici\[OAcute]n de \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" por el valor que le hemos asignado; es decir, tratar\[AAcute] \"",
  StyleBox["exp",
    FontWeight->"Bold"],
  "\" como una ",
  StyleBox["constante",
    FontWeight->"Bold"],
  ". Cuando asignes valores a expresiones es muy conveniente que las \
expresiones que utilices contengan solamente letras min\[UAcute]sculas. \
Puedes usar como s\[IAcute]mbolo para una expresi\[OAcute]n \
pr\[AAcute]cticamente cualquier combinaci\[OAcute]n de letras y \
n\[UAcute]meros. Aqu\[IAcute] asigno el valor 5 al s\[IAcute]mbolo \"a\" y el \
valor 7 al s\[IAcute]mbolo \"ab\"."
}], "Text"],

Cell[BoxData[{
    \(a = 5\), 
    \(ab = 7\)}], "Input"],

Cell["\<\
Ahora todas las apariciones de \"a\" quedan sustituidas por 5 y las de \"ab\" \
por 7.\
\>", "Text"],

Cell[BoxData[
    \(a*ab\)], "Input"],

Cell["\<\
Podemos asignar ahora otro valor para \"a\" y al hacerlo se elimina el valor \
anterior.\
\>", "Text"],

Cell[BoxData[{
    \(a = 10\), 
    \(a*ab\)}], "Input"],

Cell[TextData[{
  "Podemos preguntarle a ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "p",
  "ara saber el significado actual de un s\[IAcute]mbolo."
}], "Text"],

Cell[BoxData[
    \(\(?\ a\ \ \)\)], "Input"],

Cell[BoxData[
    \(\(?\ ab\)\)], "Input"],

Cell[TextData[{
  "Para quitar el valor asignado a una expresi\[OAcute]n usamos la orden \"",
  StyleBox["Clear[exp]",
    FontWeight->"Bold"],
  "\". "
}], "Text"],

Cell[BoxData[
    \(\(Clear[a]\  (*
      quita\ cualquier\ valor\ asignado\ al\ s\[IAcute]mbolo\ a\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(a + ab\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "El comando de asignaci\[OAcute]n diferida (",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  ")"
}], "Section"],

Cell[TextData[{
  "Es importante distinguir entre el comando de asignaci\[OAcute]n inmediata \
(=) y el comando de asignaci\[OAcute]n diferida (:=) cuyo nombre es \"",
  StyleBox["SetDelayed[ ]",
    FontWeight->"Bold"],
  "\". Cuando escribimos \"",
  StyleBox["expr1 ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\` := \)],
    FontWeight->"Bold"],
  StyleBox[" expr2\"",
    FontWeight->"Bold"],
  " ",
  StyleBox["le estamos diciendo a", "TI",
    FontSlant->"Plain"],
  StyleBox[" ", "TI"],
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  " que asigne \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" al valor diferido de \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" pero \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["no se eval\[UAcute]a inmediatamente sino que para ello hay que \
llamar a",
    FontSlant->"Italic"],
  " \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["y cada vez que lo hacemos",
    FontSlant->"Italic"],
  " \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["se eval\[UAcute]a de nuevo",
    FontSlant->"Italic"],
  ". Para que entiendas bien la diferencia, en el siguiente ejemplo uso el \
comando \"",
  StyleBox["Random[ ]",
    FontWeight->"Bold"],
  "\" que proporciona un n\[UAcute]mero aleatorio entre 0 y 1. Cada vez que \
ejecutas el comando obtienes (salvo rara casualidad) un n\[UAcute]mero \
distinto. Compru\[EAcute]balo."
}], "Text"],

Cell[BoxData[{
    \(Random[]\), 
    \(Random[]\), 
    \(Random[]\)}], "Input"],

Cell["\<\
Asignamos ahora el s\[IAcute]mbolo \"aleatorio1\" a una ejecuci\[OAcute]n \
inmediata del comando Random[ ]. Dicho comando se ejecutar\[AAcute] y el \
resultado obtenido ser\[AAcute] en adelante el valor de \"aleatorio1\".\
\>", "Text"],

Cell[BoxData[
    \(aleatorio1 = Random[]\)], "Input"],

Cell[BoxData[
    \(aleatorio1\)], "Input"],

Cell["\<\
Hacemos ahora una asignaci\[OAcute]n diferida del s\[IAcute]mbolo \
\"aleatorio2\" al comando Random[ ]. El comando Random[ ] no ser\[AAcute] \
evaluado. Para evaluarlo deberemos invocar al s\[IAcute]mbolo \"aleatorio2\" \
y cada vez que lo hagamos se ejecutar\[AAcute] de nuevo dicho comando por lo \
que el valor de \"aleatorio2\" ser\[AAcute] diferente cada vez que lo \
llamemos.\
\>", "Text"],

Cell[BoxData[
    \(aleatorio2 := Random[]\)], "Input"],

Cell[BoxData[{
    \(aleatorio2\), 
    \(aleatorio2\)}], "Input"],

Cell[TextData[{
  "Habr\[AAcute]s observado que cuando se usa el comando de \
asignaci\[OAcute]n diferida ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no presenta ninguna salida en pantalla. Eso es debido a que dicho \
comando, al igual que otros, tiene salida Null  que es un s\[IAcute]mbolo \
usado por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para indicar la ausencia de una expresi\[OAcute]n o resultado como salida \
en pantalla. Cuando un comando tiene salida Null no se imprime nada en \
pantalla."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funciones", "Section"],

Cell[TextData[{
  "En la mayor\[IAcute]a de los lenguajes de programaci\[OAcute]n para \
definir una funci\[OAcute]n es necesario declarar previamente las variables y \
el tipo de variables. En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es muy f\[AAcute]cil definir funciones. No es preciso declarar las \
variables ni el tipo de variable. Todo lo que tienes que hacer es definir la \
funci\[OAcute]n de la forma que voy a explicarte. Lo primero que tienes que \
tener en cuenta es que ",
  StyleBox["las variables de las funciones (que suelen llamarse ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["argumentos",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[
  " de la funci\[OAcute]n) van entre corchetes [ ] NUNCA entre \
par\[EAcute]ntesis ( )",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ". ",
  StyleBox[
  "Los par\[EAcute]ntesis ( ) solamente se usan para indicar, cuando es \
necesario, el orden en que debe evaluarse una expresi\[OAcute]n",
    FontWeight->"Bold"],
  ". Intentemos ya,  sin tomar m\[AAcute]s precauciones, definir una funci\
\[OAcute]n."
}], "Text"],

Cell[BoxData[
    RowBox[{\(f[x] = x^2\), " ", 
      RowBox[{"(*", 
        StyleBox[
          \(recuerda : \ 
            las\ variables\ de\ una\ funci\[OAcute]n\ van\ siempre\ entre\ 
              corchetes\),
          FontColor->RGBColor[1, 0, 0]], " ", "*)"}]}]], "Input"],

Cell["\<\
Si lo que acabamos de definir es una funci\[OAcute]n debe ser posible \
calcular su valor para distintos valores de la variable. Veamos si esto es as\
\[IAcute].\
\>", "Text"],

Cell[BoxData[{
    \(f[2]\), 
    \(f[y]\), 
    \(f[x]\)}], "Input"],

Cell[TextData[{
  "Ya ves que lo que hemos definido no es una funci\[OAcute]n. Lo que hemos \
hecho ha sido, simplemente, asignar el s\[IAcute]mbolo f[x] a x^2. \
F\[IAcute]jate en que para definir una funci\[OAcute]n las variables deben \
ser independientes de los s\[IAcute]mbolos con que las representemos. La \
funci\[OAcute]n que queremos definir es una regla que a \"algo\" le asigna \
\"algo^2\". Pero ese \"algo\" no puede identificarse con nada concreto porque \
unas veces puede ser un n\[UAcute]mero y otras veces puede ser una expresi\
\[OAcute]n algebraica o de otro tipo. Lo que necesitamos es proporcionarle a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " un ",
  StyleBox["patr\[OAcute]n o modelo",
    FontWeight->"Bold"],
  " (",
  StyleBox["pattern",
    FontSlant->"Italic"],
  " en ingl\[EAcute]s) que pueda ser reemplazado de muy diversas formas. Esto \
se hace en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " con el operador \"",
  StyleBox["Blank[ ]",
    FontWeight->"Bold"],
  "\" que se escribe _ (may\[UAcute]sculas+gui\[OAcute]n). "
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] = x^2\  (*
      Mathematica\ interpreta\ esto\ como\ f[algo] = algo^2\ *) \)}], "Input"],

Cell[BoxData[{
    \(f[2]\), 
    \(f[y]\), 
    \(f[x]\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interpreta ",
  StyleBox["x_",
    FontWeight->"Bold"],
  " como un comod\[IAcute]n que puede ser reemplazado por cualquier expresi\
\[OAcute]n simple."
}], "Text"],

Cell[BoxData[{
    \(f[x + y + 2  x*z]\), 
    \(f[\@x]\)}], "Input"],

Cell["\<\
La misma regla sirve para definir funciones de m\[AAcute]s de una variable. \
Aqu\[IAcute] tienes algunos ejemplos.\
\>", "Text"],

Cell[BoxData[{
    \(g[x_, y_] = \@\(x^2 + \(y^2\ \)\) (*
      Mathematica\ interpreta\ esto\ como\ g[algo, otroalgo] = 
        \@\(algo^2 + otroalgo^2\)*) \), 
    \(g[1, 2]\), 
    \(g[u + v, s + t]\), 
    \(Clear[f, g]\)}], "Input"],

Cell["\<\
Para definir una funci\[OAcute]n puedes usar la asignaci\[OAcute]n inmediata \
como hemos hecho antes y tambi\[EAcute]n la asignaci\[OAcute]n diferida. \
Muchas veces no tiene mayor importancia cu\[AAcute]l de las dos uses pero a \
veces s\[IAcute] que la tiene. Observa.\
\>", "Text"],

Cell[BoxData[{
    \(f[x_] = N[x, 30]\  (*
      aproximaci\[OAcute]n\ decimal\ de\ x\ con\ 30\ d\[IAcute]gitos\ 
        significativos*) \), 
    \(f[Pi]\)}], "Input"],

Cell[TextData[{
  "Est\[AAcute] claro lo que ha pasado. Al definir f[x] con la asignaci\
\[OAcute]n inmediata se eval\[UAcute]a enseguida el comando N[x,30] y, como x \
no es una cantidad num\[EAcute]rica, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " da como respuesta el propio x que es lo que de aqu\[IAcute] en adelante \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interpretar\[AAcute] como f[\"deloquesea\"]."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := N[x, 30]\), 
    \(f[Pi]\)}], "Input"],

Cell["\<\
Ahora hemos definido f[x] con la asignaci\[OAcute]n diferida por lo que el \
comando N[x,30] no se eval\[UAcute]a hasta que se llama a la funci\[OAcute]n. \
\
\>", "Text"],

Cell["\<\
Como estrategia general es conveniente usar la asignaci\[OAcute]n diferida \
para definir funciones pero hay algunos casos importantes (por ejemplo, para \
definir derivadas) en los que es preferible usar la asignaci\[OAcute]n \
directa.\
\>", "Text"],

Cell[TextData[{
  "No olvides que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distingue entre may\[UAcute]sculas y min\[UAcute]sculas. Todos los \
comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " empiezan con una letra may\[UAcute]scula, por eso ",
  StyleBox["una buena estrategia para representar tus propios comandos y \
funciones es usar letras min\[UAcute]sculas",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". La orden \"",
  StyleBox["Clear[\"@\"]",
    FontWeight->"Bold"],
  "\" elimina todas las constantes y funciones que hayamos representado con \
letras ",
  StyleBox["min\[UAcute]sculas",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Si queremos eliminar todas las constantes y funciones que hemos definido \
usaremos ",
  StyleBox["Clear[\"Global`*\"]",
    FontWeight->"Bold"],
  "  (el acento que hay que usar es el que est\[AAcute] a la derecha de la \
p). "
}], "Text"],

Cell[BoxData[
    \(\(\(\ \)\(Clear["\<Global`*\>"]\)\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funciones condicionadas", "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n vamos a ver c\[OAcute]mo se pueden definir \
funciones a trozos y c\[OAcute]mo podemos imponer que una funci\[OAcute]n \
determinada trabaje solamente con cierto tipo de datos. El operador ",
  StyleBox["Condition",
    FontWeight->"Bold"],
  "  ( ",
  StyleBox["/;",
    FontWeight->"Bold"],
  " ) tiene distintos usos; el que nos interesa ahora es de la forma \"",
  StyleBox["expr1:=expr2 /; test",
    FontWeight->"Bold"],
  "\" que representa una definici\[OAcute]n que debe aplicarse solamente si \
\"",
  StyleBox["test",
    FontWeight->"Bold"],
  "\" da \"True\". Aqu\[IAcute] es indispensable usar la asignaci\[OAcute]n \
diferida porque en otro caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata de comprobar inmediatamente \"",
  StyleBox["test",
    FontWeight->"Bold"],
  "\" con valores simb\[OAcute]licos lo que produce un error. Aqu\[IAcute] \
tienes un ejemplo."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := 2 - x\  /; x < 0\), 
    \(f[x_] := x^2 /; 0 \[LessEqual] x < 1\), 
    \(f[x_] := 2 + x /; 1 \[LessEqual] x\), 
    \({f[\(-2\)], f[0], f[1]}\)}], "Input"],

Cell["Otro ejemplo.", "Text"],

Cell[BoxData[{
    \(Clear[f]\nf[x_, y_] := 
      Log[x + y] /; 0 < x + y\  && \ x^2 + y^2 < 16\nf[\(-3\), 2]\  (*
      la\ definici\[OAcute]n\ no\ se\ aplica\ por\ no\ cumplirse\ las\ 
        condiciones*) \), 
    \(f[2, 1]\nf[3, 2]\nf[3, 3]\  (*
      la\ definici\[OAcute]n\ no\ se\ aplica\ por\ no\ cumplirse\ las\ 
        condiciones*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algunas funciones usuales", "Section"],

Cell[CellGroupData[{

Cell["Funciones exponenciales", "Subsection"],

Cell[TextData[{
  "La sintaxis de la funci\[OAcute]n exponencial de base ",
  StyleBox["a",
    FontSlant->"Italic"],
  " es ",
  StyleBox["a^x",
    FontSlant->"Italic"],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`a\^x\)]],
  ". La funci\[OAcute]n exponencial cuya base es el n\[UAcute]mero E se \
representa por Exp[x] o E^x y se llama funci\[OAcute]n ",
  StyleBox["exponencial natural",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[{
    \(Exp[1.5]\  (*la\ funci\[OAcute]n\ exponencial\ natural, \ o\ sea, \ 
      de\ base\ \[ExponentialE]*) \), 
    \(E^1.5\), 
    \(2^\((3.14)\) (*
      a^x\ representa\ el\ valor\ en\ x\ de\ la\ funci\[OAcute]n\ exponencial
        \ de\ base\ a*) \)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce la propiedad principal de las exponenciales: la exponencial de una \
suma es el producto de las exponenciales de los sumandos. Observa en la celda \
siguiente el uso del operador boleano \"==\" para comprobar que dos \
expresiones simb\[OAcute]licas son iguales."
}], "Text"],

Cell[BoxData[
    \(a\^\(x + y\) == a\^x*a\^y\)], "Input"],

Cell[TextData[{
  "Dado un n\[UAcute]mero positivo ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`a \[NotEqual] 1\)]],
  ",  y un n\[UAcute]mero real ",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  ", se define el logaritmo en base ",
  StyleBox["a",
    FontSlant->"Italic"],
  " de ",
  StyleBox["x",
    FontSlant->"Italic"],
  " como el \[UAcute]nico n\[UAcute]mero real ",
  StyleBox["y",
    FontSlant->"Italic"],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`a\^y = x\)]],
  ". Los logaritmos en base E se llaman ",
  StyleBox["logaritmos naturales o neperianos",
    FontWeight->"Bold"],
  ". Los logaritmos en base distinta de E se escriben de la forma"
}], "Text"],

Cell[BoxData[
    \(\(Log[a, x]\  (*logaritmo\ de\ x\ en\ basea*) \)\)], "Input"],

Cell[TextData[{
  "El logaritmo de un n\[UAcute]mero ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en base 10 se representa por Log[10,",
  StyleBox["x",
    FontSlant->"Italic"],
  "]."
}], "Text"],

Cell[BoxData[{
    \(Log[E] (*Log\ es\ el\ logaritmo\ natural*) \), 
    \(Log[10, N[E]] (*este\ es\ el\ logaritmo\ decimal\ de\ E*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funciones trigonom\[EAcute]tricas", "Subsection"],

Cell[TextData[{
  "Las principales funciones trigonom\[EAcute]tricas de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " son Sin[x], Cos[x], Tan[x], ArcSin[x], ArcCos[x], ArcTan[x]."
}], "Text"],

Cell[BoxData[{
    \(Sin[Pi/3]\  (*funci\[OAcute]n\ seno*) \), 
    \(ArcSin[%]\), 
    \(Cos[Pi/3]\  (*funci\[OAcute]n\ coseno*) \), 
    \(ArcCos[%]\), 
    \(Tan[Pi/3]\  (*funci\[OAcute]n\ tangente*) \), 
    \(ArcTan[%]\)}], "Input"],

Cell[TextData[{
  "Ejecuta la siguiente celda y procura entender la respuesta de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[{
    \(ArcSin[Sin[5  Pi/2]] (*no\ es\ igual\ a\ 5  Pi/2*) \ \), 
    \(ArcCos[Cos[3  Pi]] (*no\ es\ igual\ a\ 3  Pi*) \), 
    \(ArcTan[Tan[3  Pi/4]] (*no\ es\ igual\ a\ 3  Pi/4*) \)}], "Input"],

Cell["\<\
Es importante resaltar que todas estas funciones trabajan por defecto en \
radianes. Se puede trabajar en grados sexagesimales a\[NTilde]adiendo el s\
\[IAcute]mbolo \"\[Degree]\" que tienes en la paleta. Tambi\[EAcute]n puedes \
escribir \"Degree\".\
\>", "Text"],

Cell[BoxData[{
    \(Sin[45  \[Degree]]\), 
    \(Sin[45  Degree]\)}], "Input"],

Cell[TextData[{
  "Naturalmente, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " convierte la medida en grados en la medida en radianes multiplicando por \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\/180\)]],
  ". Vamos a comprobarlo."
}], "Text"],

Cell[BoxData[{
    \(N[45  \[Degree]]\), 
    \(N[45\ \[Pi]\/180]\)}], "Input"],

Cell[BoxData[{
    \(N[Degree]\), 
    \(N[\[Pi]\/180]\)}], "Input"],

Cell[TextData[{
  "Es decir, el s\[IAcute]mbolo \"\[Degree]\" es equivalente a \"Degree\" y \
es una constante num\[EAcute]rica igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\/180\)]],
  "que es el factor de conversi\[OAcute]n de grados a radianes. "
}], "Text"],

Cell["\<\
Prueba a buscar en la ayuda c\[OAcute]mo se escriben otras funciones como la \
secante, cosecante o cotangente. De todas formas, si se te olvidan, siempre \
puedes escribirlas como cociente de las anteriores.\
\>", "Text"],

Cell[TextData[{
  "Ya habr\[AAcute]s observado que todos los comandos y funciones de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " empiezan por may\[UAcute]sculas. Por eso ",
  StyleBox[
  "es conveniente que las funciones que t\[UAcute] definas tengan nombre en \
letras min\[UAcute]sculas. ",
    FontWeight->"Bold"]
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algunos comandos para trabajar con funciones elementales", "Section"],

Cell["\<\
Los siguientes comandos son \[UAcute]tiles para trabajar con funciones polin\
\[OAcute]micas.\
\>", "Text"],

Cell[BoxData[
    \(\(poli = Expand[\((x\  + \ y^2\  + z^3)\)^10] (*
      desarrolla\ la\ potencia*) \)\)], "Input"],

Cell["\<\
Lo contrario de desarrollar una potencia es agrupar en factores (cuando se \
puede). \
\>", "Text"],

Cell[BoxData[
    \(Factor[poli]\)], "Input"],

Cell[TextData[{
  "Recuerda que el s\[IAcute]mbolo \"",
  StyleBox["%",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["se refiere a la salida inmediata anterior",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(Expand[\((x + y + z)\) \((x^2 + y^3 + z^4 + 2)\) \((1 + 
            x^2)\)]\)], "Input"],

Cell[BoxData[
    \(Factor[%]\)], "Input"],

Cell[BoxData[{
    \(poli2 = Expand[\((1 + x + y*x\  + \ x*z^2)\)^3]\n\t\t\t\), 
    \(Collect[poli2, x]\  (*
      agrupa\ t\[EAcute]rminos\ con\ igual\ potencia\ de\ x*) \)}], "Input"],

Cell[BoxData[
    \(\(Coefficient[poli2, x^3] (*nos\ da\ el\ coeficiente\ de\ x^3*) \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Exponent[poli2, z]\n
    \n (*nos\ da\ el\ exponente\ m\[AAcute]ximo\ de\ z, \ es\ decir, \ 
      el\ grado\ de\ poli2\ en\ la\ variable\ z*) \)\)], "Input"],

Cell[TextData[{
  "El comando \"",
  StyleBox["Simplify[expr]",
    FontWeight->"Bold"],
  "\" sirve para simplificar una expresi\[OAcute]n. Cuando se usa con \
polinomios trata de presentarlos de la forma m\[AAcute]s sencilla y para ello \
puede factorizarlos o no."
}], "Text"],

Cell[BoxData[
    \(Simplify[\((1 - x)\)^4 - \((1 + x)\)^3]\)], "Input"],

Cell[BoxData[
    \(Simplify[\((1 - x)\)^4 + \((1 + x)\)^3]\)], "Input"],

Cell[TextData[{
  "Un comando m\[AAcute]s poderoso (y m\[AAcute]s lento) que Simplify es \"",
  StyleBox["FullSimplify[expr]",
    FontWeight->"Bold"],
  "\". A veces el primero no da resultado y el segundo s\[IAcute]."
}], "Text"],

Cell[BoxData[
    \(\(Simplify[
      2^\((1/2)\) + 3^\((1/2)\) - \((5 + 2*6^\((1/2)\))\)^\((1/2)\)] (*
      no\ hace\ nada*) \)\)], "Input"],

Cell[BoxData[
    \(\(FullSimplify[
      2^\((1/2)\) + 3^\((1/2)\) - \((5 + 2*6^\((1/2)\))\)^\((1/2)\)]\  (*
      simplifica\ la\ expresi\[OAcute]n*) \)\)], "Input"],

Cell[TextData[{
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce las identidades trigonom\[EAcute]tricas y puede usarlas para \
simplificar expresiones en las que aparezcan dichas funciones. En lugar de \
Expand[ ] y Factor[ ] se usan los comandos TrigExpand[ ] y TrigFactor[ ]."
}], "Text"],

Cell[BoxData[
    \(TrigExpand[Cos[x + y]]\)], "Input"],

Cell[BoxData[
    \(TrigExpand[Sin[2  ArcTan[t]]]\)], "Input"],

Cell[BoxData[
    \(\(TrigReduce[Sin[a*x]*Cos[b*x]\^2] (*
      convierte\ productos\ de\ funciones\ trigonom\[EAcute]tricas\ en\ 
        sumas*) \)\)], "Input"],

Cell[BoxData[
    \(TrigFactor[%]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listas", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " una lista es cualquier expresi\[OAcute]n que empiece con \"{\" y termine \
con \"}\". Ejemplos de listas son {1,2,3}, {Cos[x],Sin[y]}, {a,{b,c}}, \
{{1,2},{3,4}}. Una lista es realmente un vector (cuyos elementos pueden ser \
de muy variada naturaleza) por eso el orden en que se escriben sus elementos \
es importante."
}], "Text"],

Cell[BoxData[
    \(\({1, 2} == {2, 1}\  (*son\ listas\ distintas*) \)\)], "Input"],

Cell["\<\
Los comandos que se usan con mayor frecuencia para generar listas son Table[ \
] y Range[ ].\
\>", "Text"],

Cell["\<\
Table[expr, {k}] genera una lista con k copias de expr. 
Table[expr, {i, imax}] genera una lista de los valores de expr cuando i \
recorre los valores 1,2,... hasta imax. 
Table[expr, {i, imin, imax}] genera una lista de los valores de expr cuando i \
recorre los valores imin, imin+1,... hasta llegar sin exceder imax. Los \
valores imin, imax pueden o no ser enteros.
Table[expr, {i, imin, imax, inc}] igual que el anterior pero con incrementos \
iguales a inc. 
Table[expr, {i, imin, imax}, {j, jmin, jmax}, \[Ellipsis] ] produce una lista \
de listas (una lista anidada). Para cada valor del \[IAcute]ndice i se \
recorren todos los valores del \[IAcute]ndice j.
Range[k] genera una lista con los primeros k enteros positivos.
Range[a, b] genera una lista que empieza en a con incrementos de una unidad \
hasta llegar a b sin excederlo. Los n\[UAcute]meros a y b pueden o no ser \
enteros.
Range[a, b, inc]  igual que el anterior pero con incrementos iguales a inc. \
\
\>", "Text"],

Cell[BoxData[{
    \(Table[Sin[x], {3}]\), 
    \(Table[Random[\ ], {10}]\  (*
      genera\ 10\ n\[UAcute]meros\ aleatorios\ comprendidos\ entre\ 0\ y\ 1*) 
      \), 
    \(Table[2^i, {i, 6}]\), 
    \(Table[i^2, {i, 3, 7}]\), 
    \(Table[i^2, {i, 3.5, 7}]\), 
    \(Table[i^2, {i, 3.5, 7, 0.5}]\), 
    \(Table[n^m, {m, 2}, {n, 3.5, 7, 0.5}]\), 
    \(Range[5]\), 
    \(Range[2.7, 9]\), 
    \(Range[2.7, 9,  .8]\)}], "Input"],

Cell["\<\
Cuando tengas que trabajar con listas de muchos elementos el comando Range[ ] \
suele ser m\[AAcute]s r\[AAcute]pido que Table[ ].\
\>", "Text"],

Cell[BoxData[{
    \(\(Timing[Table[i, {i, 200000}]]\)[\([1]\)]\  (*
      tiempo\ que\ tarda\ Table[\ ]\ en\ generar\ los\ primeros\ doscientos\ 
        mil\ n\[UAcute]meros*) \t\t\), 
    \(\(Timing[Range[200000]]\)[\([1]\)]\n (*
      tiempo\ que\ tarda\ Range[\ ]\ en\ generar\ los\ primeros\ doscientos\ 
        mil\ n\[UAcute]meros*) \)}], "Input"],

Cell[TextData[{
  StyleBox["Una particularidad de ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " extraordinariamente \[UAcute]til es que casi todas las funciones de ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" pueden trabajar con listas.",
    FontWeight->"Bold"],
  " Aqu\[IAcute] tienes unos ejemplos."
}], "Text"],

Cell[BoxData[{
    \(Sin[Range[1. , 2,  .1]]\), 
    \(Range[1, 7]^2\), 
    \(1/Range[1, 7]\), 
    \({Range[1, 3], Range[4, 7]}^2\)}], "Input"],

Cell["\<\
El comando Length[lista] proporciona el n\[UAcute]mero de elementos de una \
lista.\
\>", "Text"],

Cell[BoxData[{
    \(Length[{1, 2, 3, 4}] (*una\ lista\ con\ 4\ elementos*) \), 
    \(Length[{1, {2, 3, 4}}] (*una\ lista\ con\ 2\ elementos*) \)}], "Input"],

Cell["\<\
Una matriz es una lista cuyos elementos son listas simples (las filas) de \
igual longitud (n\[UAcute]mero de columnas).\
\>", "Text"],

Cell[BoxData[
    \(\(A = Table[\(-i\)*j + 2  j, {i, 3}, {j, 4}]\  (*
      una\ matriz\ de\ 3\ filas\ y\ 4\ columnas\ *) \)\)], "Input"],

Cell[TextData[StyleBox[
"Podemos sumar y multiplicar listas de igual longitud. El producto y la suma \
de listas se hace elemento a elemento, es decir, se multiplican o se suman \
los elementos que ocupan el mismo lugar en cada una de las listas.",
  FontWeight->"Bold"]], "Text"],

Cell[BoxData[
    \(\({a, b, 
        c} + {x, y, z}\  (*suma\ de\ listas\ *) \n{a, b, c} {x, y, z}\  (*
          producto\ de\ listas\ elemento\ a\ elemento\ *) 
          \n{{a, b}, {1, 2, 3}} {{2, 3}, {x, y, z}}\  (*
      producto\ de\ listas\ elemento\ a\ elemento\ *) \)\)], "Input"],

Cell["\<\
Para multiplicar dos matrices con las dimensiones apropiadas se escribe \".\" \
entre ellas dos. Para multiplicar matrices debes representarlas como \
listas.\
\>", "Text"],

Cell[BoxData[
    \(B = Table[i*j - 2  j, {i, 4}, {j, 3}]\)], "Input"],

Cell[BoxData[
    \(M = A . B\)], "Input"],

Cell["Observa la diferencia.", "Text"],

Cell[BoxData[{
    \(M\ M\  (*producto\ como\ listas\ M*M = M^2*) \), 
    \(M . M\  (*producto\ matricial*) \), 
    \({a, b, c} {x, y, z}\  (*producto\ como\ listas*) \), 
    \({a, b, c} . {x, y, z}\  (*producto\ escalar\ de\ dos\ vectores*) \)}], 
  "Input"],

Cell["\<\
El comando Reverse[lista] invierte el orden de los elementos de la lista.\
\>", "Text"],

Cell[BoxData[
    \(Reverse[{a, b, c, d, e}]\)], "Input"],

Cell["\<\
El comando Transpose[listadelistas] intercambia los primeros dos niveles en \
\"listadelistas\". Cuando se trata de una matriz cambia filas por columnas.\
\>", "Text"],

Cell[BoxData[
    \(Transpose[A]\)], "Input"],

Cell[BoxData[
    \(% // MatrixForm\)], "Input"],

Cell[BoxData[
    \(Transpose[{{{1, 2}, {3, 4}}, {5, 6}, {7, 8}}]\)], "Input"],

Cell["\<\
El comando Sort[lista] ordena los elementos de una lista. Last[lista] y \
First[lista] nos dan el \[UAcute]ltimo y el primer elemento de una lista. \
Max[lista] y Min[lista] nos dan el m\[AAcute]ximo y el m\[IAcute]nimo \
elemento de una lista num\[EAcute]rica.\
\>", "Text"],

Cell[BoxData[{
    \(Sort[{u, x, v, c, a, f, e}]\ \  (*ordena\ lexicogr\[AAcute]ficamente*) 
      \), 
    \(Sort[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \  (*
      ordena\ de\ menor\ a\ mayor*) \), 
    \(Last[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \  (*
      \[UAcute]ltimo\ elemento*) \t\), 
    \(First[{u, x, v, c, a, f, e}]\ \ \  (*primer\ elemento*) \), 
    \(Max[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \ \), 
    \(Min[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \)}], "Input"],

Cell["\<\
Un comando que es muy \[UAcute]til para trabajar con listas es el comando \
Flatten[ ] que convierte una lista de listas en una lista.\
\>", "Text"],

Cell[BoxData[
    \(Flatten[{{1, 2, 3}, {4, 5, 6}, {{7, 8}, {9, 10}}}]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de centenares de comandos para trabajar con listas. Lo mejor es \
que si alguna vez quieres hacer alguna operaci\[OAcute]n con listas consultes \
la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " y es muy posible que haya un comando que facilite tu trabajo."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Aplicar una funci\[OAcute]n a los elementos de una lista. El comando  Map[ \
]\
\>", "Section"],

Cell[TextData[{
  "En general, para aplicar una funci\[OAcute]n a los elementos de una lista, \
se usa el comando Map[funcion,lista] donde \"funcion\" debe ser el ",
  StyleBox["nombre",
    FontSlant->"Italic"],
  " de la funci\[OAcute]n."
}], "Text"],

Cell[BoxData[{
    \(Map[funcion, {a, b, c}]\), 
    \(Map[1/x, {1, 2, 3}]\  (*no\ es\ correcto*) \), 
    \(inverso[x_] := 1/x\), 
    \(Map[inverso, {1, 2, 3}]\)}], "Input"],

Cell["\<\
Con mucha frecuencia hay que aplicar una funci\[OAcute]n de varias variables \
a un vector o a los elementos de una lista cuyos elementos son vectores con \
igual n\[UAcute]mero de elementos que variables tiene la funci\[OAcute]n. La \
forma m\[AAcute]s sencilla de hacer esto es definir la funci\[OAcute]n de \
manera que pueda evaluarse en vectores. Observa\
\>", "Text"],

Cell[BoxData[{
    \(f[x_, y_] = x + y\^2; \n
    Map[f, {{1, 2}, {3, 4}}] (*tal\ como\ est\[AAcute]\ definida, \ 
      la\ funci\[OAcute]n\ no\ puede\ evaluarse\ en\ vectores*) \), 
    \(f[{x_, y_}] = x + y\^2;  (*
      definimos\ la\ funci\[OAcute]n\ de\ forma\ que\ tambi\[EAcute]n\ pueda\ 
        evaluarse\ en\ vectores*) \n
    Map[f, {{1, 2}, {3, 4}}] (*
      ahora\ la\ funci\[OAcute]n\ puede\ evaluarse\ en\ vectores*) \)}], 
  "Input"],

Cell[TextData[{
  StyleBox[
  "Cuando definas una funci\[OAcute]n has de tener en cuenta el tipo de \
variable con el que va a trabajar dicha funci\[OAcute]n y definirla de forma \
adecuada",
    FontWeight->"Bold"],
  ". En el siguiente ejemplo se define una funci\[OAcute]n de 3 variables que \
puede evaluarse directamente sobre listas de la forma {{x},{y,z}}."
}], "Text"],

Cell[BoxData[{
    \(funcion[x_, y_, z_] = {Sin[x], y + z}; \n
    funcion[{{x_}, {y_, z_}}] = {Sin[x], y + z}; 
    \n{funcion[Pi/4, 2, 3], funcion[{{Pi/4}, {2, 3}}]}\), 
    \(Map[funcion, Table[{{k\ Pi/2}, {k + 1, k + 2}}, {k, 1, 5}]]\), 
    \(Clear[funcion]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Sumar y multiplicar elementos de una lista. Los comandos Apply[Plus,lista] y \
Apply[Times, lista]\
\>", "Section"],

Cell["\<\
Con frecuencia hay que sumar o multiplicar todos los elementos de una lista \
lo que se hace con los comandos Apply[Plus,lista] y Apply[Times,lista].\
\>", "Text"],

Cell[BoxData[{
    \(Apply[Plus, Range[1, 1000]]\  (*
      suma\ de\ los\ 1000\ primeros\ n\[UAcute]meros*) \), 
    \(Apply[Times, Range[1, 10]]\  (*
      producto\ de\ los\ 10\ primeros\ n\[UAcute]meros*) \), 
    \(Apply[Plus, {{2, 3}, {4, 5}}]\  (*
      suma\ las\ listas\ elemento\ a\ elemento*) \), 
    \(Apply[Times, {{2, 3}, {4, 5}}]\  (*
      multiplica\ las\ listas\ elemento\ a\ elemento*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Sumar y multiplicar elementos de una sucesi\[OAcute]n. Comandos Sum[ ] y \
Product[ ]\
\>", "Section"],

Cell["\<\
Supongamos que hemos definido una funci\[OAcute]n que toma valores num\
\[EAcute]ricos. Por ejemplo:\
\>", "Text"],

Cell[BoxData[
    \(\(f[x_] = Sin[x^2]; \)\)], "Input"],

Cell[TextData[{
  "Queremos sumar los valores de esa funci\[OAcute]n en los puntos de la \
forma ",
  Cell[BoxData[
      \(TraditionalForm\`k\/1000\)]],
  " para valores de k desde 1 a 1000. Con lo que hasta ahora hemos visto, eso \
podemos hacerlo como sigue (",
  StyleBox["observa el uso del punto decimal en 1000. para evitar que ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" trabaje simb\[OAcute]licamente",
    FontWeight->"Bold"],
  ")."
}], "Text"],

Cell[BoxData[
    \(Apply[Plus, Map[f, Table[k/1000. , {k, 1000}]]]\)], "Input"],

Cell[TextData[{
  "Esto mismo puede usarse con el comando Sum[ ] cuya sintaxis es ",
  Cell[BoxData[
      \(TraditionalForm\`\(Sum[\(f[x\_k\)\)\)]],
  "],{k,ini,fin}] y que puedes introducirlo con la ayuda de la paleta como ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%1000 f[x\_k]\)]],
  " pero debes procurar que este c\[AAcute]lculo se haga \
num\[EAcute]ricamente."
}], "Text"],

Cell[BoxData[{
    \(Sum[f[k/1000. ], {k, 1, 1000}]\), 
    \(\[Sum]\+\(k = 1\)\%1000 f[k/1000. ]\)}], "Input"],

Cell["Puedes proceder de forma an\[AAcute]loga para calcular productos.", 
  "Text"],

Cell[BoxData[
    \(Apply[Times, Map[f, Table[k/100. , {k, 100}]]]\)], "Input"],

Cell[BoxData[{
    \(Product[f[k/100. ], {k, 1, 100}]\), 
    \(\[Product]\+\(k = 1\)\%100 f[k/100. ]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seleccionar elementos en una lista: el comando Select[ ]", "Section"],

Cell["\<\
Para seleccionar el elemento que ocupa el lugar k en una lista se usa la \
sintaxis \"lista[[k]]\".\
\>", "Text"],

Cell[BoxData[{
    \({a, b, c, d}[\([2]\)]\  (*segundo\ elemento\ de\ la\ lista*) \), 
    \(\t\tA = Table[\(-i\)*j + 2  j, {i, 3}, {j, 4}]\  (*
      una\ matriz\ de\ 3\ filas\ y\ 4\ columnas*) \), 
    \(A[\([1]\)]\  (*primer\ elemento\ de\ la\ lista*) \)}], "Input"],

Cell["\<\
En una lista de listas se usa la sintaxis \"lista[[i,j]]\" para seleccionar \
el elemento que ocupa el lugar i de la lista (la fila) y dentro de \[EAcute]l \
el que ocupa el lugar j (la columna).\
\>", "Text"],

Cell[BoxData[
    \(A[\([1, 4]\)]\)], "Input"],

Cell[TextData[{
  StyleBox["Una forma frecuente de seleccionar elementos en una lista se basa \
en el comando Select[lista,criterio de selecci\[OAcute]n]. Hay que definir \
previamente el criterio de selecci\[OAcute]n el cual debe ser una funci\
\[OAcute]n boleana.",
    FontWeight->"Bold"],
  " Para definir esa funci\[OAcute]n es obligado que uses la \
asignaci\[OAcute]n diferida porque en otro caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tratar\[AAcute] de evaluar inmediatamente la expresi\[OAcute]n a la \
derecha lo que dar\[AAcute] un error. Aqu\[IAcute] tienes algunos ejemplos."
}], "Text"],

Cell[BoxData[{
    \(mayorque7[x_] := x > 7\  (*
      funci\[OAcute]n\ boleana\ que\ sirve\ para\ seleccionar\ n\[UAcute]meros
        \ mayores\ que\ 7*) \), 
    \(Select[Range[\(-2\), 10], mayorque7]\)}], "Input"],

Cell[BoxData[{
    \(multiplodetres[x_] := IntegerQ[x/3]\  (*
      IntegerQ[z]\ es\ True\ si\ z\ es\ entero\ y\ False\ en\ otro\ caso*) 
      \), 
    \(Select[Range[\(-15\), 15], multiplodetres]\  (*
      seleccionamos\ los\ m\[UAcute]ltiplos\ de\ 3*) \)}], "Input"],

Cell["\<\
Las funciones boleanas OddQ, EvenQ, IntegerQ, NumberQ, VectorQ, PrimeQ, \
NumericQ, Positive, Negative pueden usarse como criterios de \
selecci\[OAcute]n. \
\>", "Text"],

Cell[BoxData[{
    \(Select[Table[3*k, {k, 15}], EvenQ]\  (*
      selecciona\ los\ n\[UAcute]meros\ pares*) \), 
    \(Select[Table[3*k, {k, 15}], OddQ]\  (*
      selecciona\ los\ n\[UAcute]meros\ impares*) \), 
    \(Select[{1, {2, 3}, a, {c}, {{d, e}}}, VectorQ]\  (*
      selecciona\ listas\ simples*) \), 
    \(Select[Sin[Range[2. , 5. ,  .25]], Positive]\), 
    \(Select[Sin[Range[2. , 5. ,  .25]], Negative]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Convertir procedimientos en funciones (Opcional)", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es muy f\[AAcute]cil convertir procedimientos en funciones. Es decir, una \
vez que has realizado una tarea para un caso concreto es muy sencillo definir \
una funci\[OAcute]n que realice esa misma tarea en cualquier \
situaci\[OAcute]n an\[AAcute]loga. Consideremos el siguiente procedimiento \
que consiste en seleccionar entre los primeros 10000 enteros aquellos que son \
cuadrados perfectos."
}], "Text"],

Cell[BoxData[
    \(cuadrado[x_] := IntegerQ[Sqrt[x]]; \n
    Select[Range[1, 10000], cuadrado]\)], "Input"],

Cell["\<\
Para convertir este procedimiento en una funci\[OAcute]n tomamos como \
variable la lista a la que se va a aplicar y la funci\[OAcute]n de selecci\
\[OAcute]n la mantenemos igual. Ello nos lleva a definir la funci\[OAcute]n \
siguiente.\
\>", "Text"],

Cell[BoxData[
    \(seleccionacuadrados[z_] := Select[z, cuadrado]\)], "Input"],

Cell["\<\
Naturalmente para que esta funci\[OAcute]n haga su trabajo debemos definir \
antes el criterio de selecci\[OAcute]n \"cuadrado\". Adem\[AAcute]s la \
variable z debe ser una lista. Por ejemplo, podemos seleccionar de entre los \
primeros 100 cubos aquellos que tambi\[EAcute]n son cuadrados.\
\>", "Text"],

Cell[BoxData[
    \(seleccionacuadrados[Table[k^3, {k, 1, 100}]]\)], "Input"],

Cell["\<\
Podemos definir funciones cuyas variables son funciones. Por ejemplo la funci\
\[OAcute]n siguiente lo que hace es evaluar una funci\[OAcute]n f en los \
puntos de una lista y despu\[EAcute]s suma los valores obtenidos.\
\>", "Text"],

Cell[BoxData[
    \(sumalista[funcion_, lista_] := Apply[Plus, Map[funcion, lista]]\)], 
  "Input"],

Cell["\<\
Para que este comando act\[UAcute]e debemos pasarle una \"funci\[OAcute]n\" \
que pueda actuar sobre los elementos de \"lista\" y proporcione resultados \
que puedan sumarse.\
\>", "Text"],

Cell[BoxData[
    \(f[x_] := x^2 + Exp[x]; \nsumalista[f, Range[10]]\)], "Input"],

Cell[BoxData[
    \(f[{x_, y_}] = {x, x + y}; \nsumalista[f, Table[{n, n}, {n, 10}]]\)], 
  "Input"],

Cell[TextData[{
  "Una forma de decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que haga varias cosas pero que solamente muestre en pantalla la \
\[UAcute]ltima operaci\[OAcute]n, es usar una lista con todas las cosas que \
queremos que haga separadas por punto y coma. Por ejemplo."
}], "Text"],

Cell[BoxData[{
    \(Clear[seleccionacuadrados, cuadrado]\), 
    \(seleccionacuadrados[x_] := {
        cuadrado[z_] := IntegerQ[Sqrt[z]]\  (*
          aqu\[IAcute]\ definimos\ el\ criterio\ de\ selecci\[OAcute]n\ y\ no
            \ se\ puede\ repetir\ la\ variable\ x*) ; Select[x, cuadrado]}
        \), 
    \(seleccionacuadrados[Range[10000]]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reglas de sustituci\[OAcute]n. Operador de sustituci\[OAcute]n", \
"Section"],

Cell["\<\
Cuando queremos sustituir en una expresi\[OAcute]n un s\[IAcute]mbolo por un \
valor o por otro s\[IAcute]mbolo puede no ser conveniente usar el comando de \
asignaci\[OAcute]n (=) porque dicho comando atribuye un valor fijo \"para \
siempre\". El siguiente ejemplo explica lo que quiero decirte.\
\>", "Text"],

Cell[BoxData[
    \(\(polixy = x*y^2 + 3  x + 4  y\ 
    \n (*una\ expresi\[OAcute]n\ algebraica\ en\ la\ que\ intervienen\ dos\ 
        variables\ "\<x\>"\ e\ "\<y\>"\ *) \)\)], "Input"],

Cell["\<\
Podemos querer sustituir en dicha expresi\[OAcute]n la variable \"x\" por 7. \
Una forma de hacerlo es como sigue.\
\>", "Text"],

Cell[BoxData[
    \(\(\(x = 7\n
    polixy\)\(\ \ \ \)\)\)], "Input"],

Cell[TextData[{
  "El inconveniente de esto es que \"polixy\" ha cambiado y \"x\" ya no es \
una variable. Hay otra forma de proceder que consiste en decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \"sustituye x por 7\" pero deja \"polixy\" igual que est\[AAcute] y adem\
\[AAcute]s \"x\" debe seguir siendo una variable. Para ello necesitas DOS \
comandos: una ",
  StyleBox["regla de sustituci\[OAcute]n",
    FontWeight->"Bold"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`x -> 7\)]],
  ") y el ",
  StyleBox["comando de sustituci\[OAcute]n",
    FontWeight->"Bold"],
  " ( ",
  StyleBox["/.",
    FontWeight->"Bold"],
  " ). Una",
  StyleBox[" regla de sustituci\[OAcute]n inmediata",
    FontWeight->"Bold"],
  " es un comando de la forma \"",
  Cell[BoxData[
      \(TraditionalForm\`expr1 -> expr2\)],
    FontWeight->"Bold"],
  "\" que representa una regla que transforma \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" en \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\". Puedes escribir ",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  " con mejor apariencia tecleando \"Esc",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "Esc\". Este es el resultado \[Rule]. Por s\[IAcute] sola una regla no hace \
nada. Para aplicar una regla necesitas el operador de sustituci\[OAcute]n \
cuya sintaxis es de la forma \"",
  StyleBox["expr /. regla",
    FontWeight->"Bold"],
  "\" o \"",
  StyleBox["expr /. {regla1, regla2,...}",
    FontWeight->"Bold"],
  "\" que aplica una regla o varias reglas ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de evaluar \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\". Por ejemplo \"",
  StyleBox["expr1 /. b\[Rule]c",
    FontWeight->"Bold"],
  "\"",
  StyleBox[" ",
    FontWeight->"Bold"],
  "significa que en la expresi\[OAcute]n \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["despu\[EAcute]s de ser evaluada",
    FontSlant->"Italic"],
  " todas las apariciones de ",
  StyleBox["b",
    FontWeight->"Bold"],
  " deben ser sustituidas por ",
  StyleBox["c",
    FontWeight->"Bold"],
  ". Observa su uso."
}], "Text"],

Cell[BoxData[{
    \(Clear[x]\ \ \ \  (*limpiamos\ el\ s\[IAcute]mbolo\ x\ *) \), 
    \(polixy\ \ \ \ \ \ \ \ \  (*polixy\ vuelve\ a\ ser\ lo\ que\ era\ *) \n
        polixy /. x \[Rule] 7\ \ \ \ \n
    \t\t (*atribuimos\ a\ x\ el\ valor\ 7\ obteniendo\ igual\ resultado\ que\ 
        antes\ *) \), 
    \(polixy\ \ \ \ \ \ \ \ \  (*polixy\ no\ ha\ cambiado\ *) \)}], "Input"],

Cell[BoxData[
    \(\(?x\ \ \ \ (*x\ sigue\ siendo\ una\ variable\ *)\)\)], "Input"],

Cell[TextData[{
  " Cuando en un comando del tipo \"",
  StyleBox["expr /. regla",
    FontWeight->"Bold"],
  "\" no puede aplicarse ninguna regla de sustituci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " devuelve \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" sin cambio ninguno."
}], "Text"],

Cell[BoxData[
    \(a + 3  b /. c \[Rule] 2\)], "Input"],

Cell[TextData[{
  "Es importante advertir que ",
  StyleBox["el operador de sustituci\[OAcute]n aplica las reglas de sustituci\
\[OAcute]n exactamente una sola vez en cada parte de la expresi\[OAcute]n que \
hay a su izquierda",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(3 \( x\^2\) Cos[1 + x + x\^2] /. {x\^2 \[Rule] x, 
        x \[Rule] a}\)], "Input"],

Cell["\<\
Si aplicamos una lista de listas de reglas de sustituci\[OAcute]n obtenemos \
como resultado una lista cuyos elementos se obtienen aplicando cada una de \
las reglas de sustituci\[OAcute]n a la expresi\[OAcute]n que hay a la \
izquierda.\
\>", "Text"],

Cell[BoxData[
    \(3 \( x\^2\) 
        Cos[1 + x + x\^2] /. {{x\^2 \[Rule] x}, {x \[Rule] a}}\)], "Input"],

Cell["\<\
Puedes aplicar reglas de sustituci\[OAcute]n a \"patrones\" de forma parecida \
a como se definen funciones. Aqu\[IAcute] tienes dos ejemplos. \
\>", "Text"],

Cell[BoxData[
    \({1, 2, 3, {4, 5}, 6} /. x_?NumberQ \[Rule] {x, 0}\)], "Input"],

Cell[TextData[{
  "Esta regla le dice a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que busque los n\[UAcute]meros \"x\" que hay en la expresi\[OAcute]n de \
la izquierda y los sustituya por {x,0}. Observa la gran diferencia."
}], "Text"],

Cell[BoxData[
    \({1, 2, 3, {4, 5}, 6} /. x_ \[Rule] {x, 0}\)], "Input"],

Cell[TextData[{
  "La siguiente regla le dice a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que busque en la expresi\[OAcute]n de la izquierda los elementos de la \
forma \"f[algo]\" y los sustituya por algo^2."
}], "Text"],

Cell[BoxData[
    \(f[a] + f[a + b] + f[b*c] \((u + v)\) /. f[x_] \[Rule] x^2\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sobre el comando Print[ ]", "Section"],

Cell[TextData[{
  "El comando Print[\"cadena de texto\"] debe usarse ",
  StyleBox["muy poco",
    FontWeight->"Bold"],
  " en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". No olvides que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " saca ",
  StyleBox["todo",
    FontSlant->"Italic"],
  " en pantalla por lo que solamente hay que peocuparse de lo que NO queremos \
que muestre en pantalla (poniendo un ; al final) porque lo consideramos una \
informaci\[OAcute]n innecesaria. Pero hay que evitar usar el comando Print[ ] \
para pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que muestre en pantalla lo que el programa ya muestra por s\[IAcute] \
solo. Un inconveniente de Print[ ] es que su salida es considerada siempre \
como una cadena de texto y no puede ser utilizada en ning\[UAcute]n tipo de c\
\[AAcute]lculo num\[EAcute]rico. "
}], "Text"],

Cell[BoxData[{
    \(a = Sin[1.5]\  (*esto\ es\ un\ n\[UAcute]mero\ real*) \), 
    \(b = Print[Sin[1.5]]\  (*
      esto\ no\ es\ un\ n\[UAcute]mero\ sino\ una\ cadena\ de\ texto*) \t\t
    \), 
    \(a + a\  (*se\ puede\ evaluar*) \), 
    \(a + b\  (*no\ se\ puede\ evaluar*) \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sobre la evaluaci\[OAcute]n de funciones", "Section"],

Cell[TextData[{
  "Las funciones deben definirse en la forma f[x,y] o f[x,y,z], es decir \
deben incluir todas las variables en un corchete, pues de esta forma se \
pueden evaluar directamente. Para evaluar una funci\[OAcute]n, f[x,y] \
correctamente definida, no hay que atribuir valores a las variables porque es \
un trabajo innecesario e inconveniente. Si queremos evaluar f[x,y] en el \
punto (1,2) basta con escribir f[1,2] y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " mostrar\[AAcute] de forma autom\[AAcute]tica, sin necesidad de que \
nosotros lo pidamos, el resultado en pantalla. "
}], "Text"],

Cell[BoxData[{
    \(poli = x\^2*y + y\^3*z + x*y*z\ ;  (*definici\[OAcute]n\ incorrecta*) 
      \[IndentingNewLine]mismopoli[x_, y_, z_] = x\^2*y + y\^3*z + x*y*z\ ; 
    \[IndentingNewLine] (*
      definici\[OAcute]n\ correcta . \ Da\ igual\ aqu\[IAcute]\ que\ usemos\ 
        la\ asignaci\[OAcute]n\ inmediata\ o\ la\ diferida . \ El\ ; \ 
      evita\ la\ salida\ en\ pantalla*) 
      \[IndentingNewLine]poli /. {x \[Rule] 1, y \[Rule] 2, z -> 3}\  (*
      unica\ forma\ de\ evaluar\ "\<poli\>"\ en\ el\ punto\ \((1, 2, 3)\)\ sin
        \ atribuir\ valores\ a\ las\ variables\ x, \ y, \ z, \ cosa\ que, \ 
      adem\[AAcute]s, \ 
      no\ debemos\ hacer\ pues\ "\<poli\>"\ dejar\[IAcute]a\ de\ ser\ una\ 
        funci\[OAcute]n\ y\ pasar\[IAcute]a\ a\ ser\ una\ constante\ hasta\ 
        que\ limpi\[AAcute]ramos\ x, \ y, \ z\ con\ un\ Clear[]*) \), 
    \(mismopoli[1, 2, 3]\  (*
      esta\ es\ la\ forma\ correcta\ de\ evaluar . \ No\ debes\ hacer\ x = 1, 
      \ y = 2, \ 
      z = 3\ y\ despu\[EAcute]s\ pedir\ a\ Mathematica\ el\ valor\ 
          "\<mismopoli[x,y,z]\>"\ porque, \ aunque\ "\<mismopoli\>", \ 
      a\ diferencia\ de\ "\<poli\>", \ 
      seguir\[AAcute]\ siendo\ una\ funci\[OAcute]n, \ 
      las\ atribuciones\ hechas\ para\ x, \ y, \ 
      z\ pueden\ dar\ lugar\ a\ errores\ si\ no\ las\ limpias\ con\ un\ 
        Clear[] . \ Demasiado\ trabajo\ innecesario*) \)}], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "ExerciseMain"],

Cell[TextData[{
  "Los ejercicios que siguen te servir\[AAcute]n para comprobar si ya eres \
capaz de realizar con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " algunas de las operaciones que hemos estudiado anteriormente."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[
"Calcula\n\ta) Los primeros 100 decimales del n\[UAcute]mero \[ExponentialE].\
\n\tb) El logaritmo en base 3 de \
515377520732011331036461129765621272702107522001.\n\tc) La tangente de \
\[Pi]/2"], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ejercicio 2",
  FontWeight->"Bold"]], "Exercise"],

Cell[TextData[{
  "a) Ordena de menor a mayor los n\[UAcute]meros \[Pi], ",
  Cell[BoxData[
      \(TraditionalForm\`1068966896\/340262731\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`103993\/33102\)]],
  ".\nb) \[DownQuestion]Qu\[EAcute] n\[UAcute]mero es menor ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\^\[Pi]\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^\[ExponentialE]\)]],
  "?\nc) Explica la respuesta de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " al comando N[N[Pi, 15], 30],"
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define la funci\[OAcute]n f como ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\^\(3  x + 1\)\)]],
  "en el intervalo [0,1[ y como el logaritmo de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 1\)]],
  "en el resto de la recta \treal.\nb ) \[DownQuestion]Cu\[AAcute]nto vale f \
en 1, 2, y -7?.\nc) Usa la orden Table para calcular su valor en los primeros \
100 naturales."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Define ",
  Cell[BoxData[
      \(TraditionalForm\`listauno = Range[2, 21], \ 
      listados = Range[22, 31]\)]],
  ". Realiza las siguientes operaciones usando algunos de los comandos antes \
vistos.\na) Multiplica cada elemento de \"listauno\" por todos los elementos \
de \"listados\". El resultado ser\[AAcute] una lista con 20 elementos (que a \
su vez ser\[AAcute]n listas de 10 elementos), a la que llamar\[AAcute]s \
\"productos\".\nb) Calcula la suma de cada una de las listas que forman la \
lista \"productos\" (no te equivoques, comprueba el resultado). Obtendr\
\[AAcute]s una lista con 20 n\[UAcute]meros.\nc) Calcula el producto de los \
elementos de la lista obtenida en el apartado anterior."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell["\<\
a) Genera una lista de 30 elementos cuyos elementos sean listas de dos n\
\[UAcute]meros.
b) Usando una regla de sustituci\[OAcute]n o una funci\[OAcute]n apropiada \
transforma la lista anterior en otra en la cual la primera coordenada de cada \
lista de dos elementos se ha multiplicado por 3 y la segunda coordenada se ha \
elevado al cuadrado.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Define una funci\[OAcute]n que al actuar sobre una lista num\[EAcute]rica \
la convierta en otra lista en la que cada n\[UAcute]mero ",
  StyleBox["a",
    FontSlant->"Italic"],
  " de la lista inicial ha sido reemplazado por {{",
  StyleBox["a",
    FontSlant->"Italic"],
  ",0},{",
  StyleBox["a",
    FontSlant->"Italic"],
  ", Cos[",
  StyleBox["a",
    FontSlant->"Italic"],
  "]}}."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell["\<\
Define una funci\[OAcute]n que deber\[AAcute]s evaluar sobre las siguientes \
listas.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(lista1 = Table[{{Random[]}, {Random[]}}, {15}]\), 
    \(lista2 = Table[{Random[], {{Random[]}}}, {10}]\)}], "Input"],

Cell["\<\
Dicha funci\[OAcute]n debe convertir un par de la forma {{x},{y}} o {x,{{y}}} \
en el par {x+y,x-y}.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell["\<\
Define una funci\[OAcute]n que selecciona en una lista de n\[UAcute]meros \
aquellos que son mayores que 2 o menores que -1. Comprueba tu funci\[OAcute]n \
con una lista adecuada.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "a) Calcula num\[EAcute]ricamente y simb\[OAcute]licamente la suma de todos \
los n\[UAcute]meros de la forma ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          FormBox[\(\((\(-1\))\)\^\(k + 1\)\),
            "TraditionalForm"], \(\@k\)], TraditionalForm]]],
  "desde k=1 hasta k=1000.\nb) Calcula num\[EAcute]ricamente y \
simb\[OAcute]licamente el producto de todos los n\[UAcute]meros de la forma ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((1 + 1\/k\^2)\)\)]],
  " desde k=1 hasta k=1000."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PrintingCopies->1,
PrintingPageRange->{2, 3},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Entorno de trabajo. Aritm\[EAcute]tica. \nC\[AAcute]lculo simb\
\[OAcute]lico y aproximado. Operaciones boleanas. "], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Entorno de trabajo. Aritm\[EAcute]tica. \nC\[AAcute]lculo simb\
\[OAcute]lico y aproximado. Operaciones boleanas. "], "Header"]}},
Magnification->1,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 108, 4, 56, "Title"],
Cell[1820, 55, 203, 3, 63, "Author"],

Cell[CellGroupData[{
Cell[2048, 62, 39, 0, 56, "Section"],
Cell[2090, 64, 544, 8, 67, "Text"],
Cell[2637, 74, 1512, 28, 494, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4186, 107, 165, 5, 56, "Section"],
Cell[4354, 114, 2277, 44, 143, "Text"],
Cell[6634, 160, 1737, 37, 155, "Text"],
Cell[8374, 199, 116, 2, 62, "Input"],
Cell[8493, 203, 914, 19, 86, "Text"],
Cell[9410, 224, 464, 10, 48, "Text"],
Cell[9877, 236, 180, 3, 96, "Input"],
Cell[10060, 241, 123, 3, 29, "Text"],
Cell[10186, 246, 65, 1, 52, "Input"],
Cell[10254, 249, 356, 8, 48, "Text"],
Cell[10613, 259, 43, 1, 50, "Input"],
Cell[10659, 262, 237, 6, 29, "Text"],
Cell[10899, 270, 49, 1, 50, "Input"],
Cell[10951, 273, 1043, 33, 67, "Text"],
Cell[11997, 308, 34, 1, 50, "Input"],
Cell[12034, 311, 640, 16, 67, "Text"],
Cell[12677, 329, 457, 7, 48, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13171, 341, 61, 0, 56, "Section"],
Cell[13235, 343, 853, 15, 86, "Text"],
Cell[14091, 360, 59, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14187, 366, 50, 0, 56, "Section"],
Cell[14240, 368, 681, 12, 67, "Text"],
Cell[14924, 382, 43, 1, 50, "Input"],
Cell[14970, 385, 183, 5, 29, "Text"],
Cell[15156, 392, 44, 1, 50, "Input"],
Cell[15203, 395, 161, 3, 29, "Text"],
Cell[15367, 400, 274, 6, 29, "Text"],
Cell[15644, 408, 42, 1, 62, "Input"],
Cell[15689, 411, 45, 1, 62, "Input"],
Cell[15737, 414, 86, 2, 29, "Text"],
Cell[15826, 418, 44, 1, 62, "Input"],
Cell[15873, 421, 186, 5, 29, "Text"],
Cell[16062, 428, 37, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16136, 434, 48, 0, 56, "Section"],
Cell[16187, 436, 618, 15, 48, "Text"],
Cell[16808, 453, 612, 18, 48, "Text"],
Cell[17423, 473, 67, 1, 50, "Input"],
Cell[17493, 476, 215, 6, 29, "Text"],
Cell[17711, 484, 53, 1, 50, "Input"],
Cell[17767, 487, 544, 12, 48, "Text"],
Cell[18314, 501, 55, 1, 50, "Input"],
Cell[18372, 504, 746, 17, 67, "Text"],
Cell[19121, 523, 614, 14, 67, "Text"],
Cell[19738, 539, 635, 18, 48, "Text"],
Cell[20376, 559, 888, 19, 191, "Input"],
Cell[21267, 580, 467, 12, 48, "Text"],
Cell[21737, 594, 806, 19, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22580, 618, 39, 0, 56, "Section"],
Cell[22622, 620, 1373, 21, 191, "Text"],
Cell[23998, 643, 166, 5, 132, "Input"],
Cell[24167, 650, 194, 6, 29, "Text"],
Cell[24364, 658, 215, 4, 50, "Input"],
Cell[24582, 664, 2468, 57, 181, "Text"],
Cell[27053, 723, 1174, 21, 210, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28264, 749, 116, 5, 56, "Section"],
Cell[28383, 756, 386, 8, 48, "Text"],
Cell[28772, 766, 50, 1, 29, "Text"],
Cell[28825, 769, 279, 5, 48, "Text"],
Cell[29107, 776, 41, 1, 50, "Input"],
Cell[29151, 779, 94, 1, 29, "Text"],
Cell[29248, 782, 39, 1, 50, "Input"],
Cell[29290, 785, 283, 11, 29, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29610, 801, 138, 5, 56, "Section"],
Cell[29751, 808, 1793, 33, 256, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31581, 846, 150, 5, 56, "Section"],
Cell[31734, 853, 440, 11, 48, "Text"],
Cell[32177, 866, 137, 3, 90, "Input"],
Cell[32317, 871, 801, 15, 67, "Text"],
Cell[33121, 888, 1912, 59, 105, "Text"],
Cell[35036, 949, 57, 2, 70, "Input"],
Cell[35096, 953, 110, 3, 29, "Text"],
Cell[35209, 958, 37, 1, 50, "Input"],
Cell[35249, 961, 112, 3, 29, "Text"],
Cell[35364, 966, 56, 2, 70, "Input"],
Cell[35423, 970, 174, 6, 29, "Text"],
Cell[35600, 978, 45, 1, 50, "Input"],
Cell[35648, 981, 42, 1, 50, "Input"],
Cell[35693, 984, 164, 5, 29, "Text"],
Cell[35860, 991, 122, 3, 50, "Input"],
Cell[35985, 996, 39, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36061, 1002, 136, 5, 56, "Section"],
Cell[36200, 1009, 1493, 51, 86, "Text"],
Cell[37696, 1062, 81, 3, 90, "Input"],
Cell[37780, 1067, 246, 4, 29, "Text"],
Cell[38029, 1073, 54, 1, 50, "Input"],
Cell[38086, 1076, 43, 1, 50, "Input"],
Cell[38132, 1079, 407, 7, 48, "Text"],
Cell[38542, 1088, 55, 1, 50, "Input"],
Cell[38600, 1091, 66, 2, 70, "Input"],
Cell[38669, 1095, 549, 13, 48, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39255, 1113, 28, 0, 56, "Section"],
Cell[39286, 1115, 1186, 29, 86, "Text"],
Cell[40475, 1146, 281, 7, 50, "Input"],
Cell[40759, 1155, 185, 4, 29, "Text"],
Cell[40947, 1161, 69, 3, 90, "Input"],
Cell[41019, 1166, 1102, 26, 86, "Text"],
Cell[42124, 1194, 135, 3, 70, "Input"],
Cell[42262, 1199, 69, 3, 90, "Input"],
Cell[42334, 1204, 236, 8, 29, "Text"],
Cell[42573, 1214, 69, 2, 73, "Input"],
Cell[42645, 1218, 139, 3, 29, "Text"],
Cell[42787, 1223, 238, 6, 112, "Input"],
Cell[43028, 1231, 295, 5, 48, "Text"],
Cell[43326, 1238, 169, 4, 70, "Input"],
Cell[43498, 1244, 455, 11, 48, "Text"],
Cell[43956, 1257, 87, 3, 90, "Input"],
Cell[44046, 1262, 181, 4, 29, "Text"],
Cell[44230, 1268, 261, 5, 48, "Text"],
Cell[44494, 1275, 716, 22, 48, "Text"],
Cell[45213, 1299, 259, 7, 29, "Text"],
Cell[45475, 1308, 68, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45580, 1314, 42, 0, 56, "Section"],
Cell[45625, 1316, 954, 25, 67, "Text"],
Cell[46582, 1343, 205, 5, 130, "Input"],
Cell[46790, 1350, 29, 0, 29, "Text"],
Cell[46822, 1352, 360, 7, 150, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47219, 1364, 44, 0, 56, "Section"],

Cell[CellGroupData[{
Cell[47288, 1368, 45, 0, 46, "Subsection"],
Cell[47336, 1370, 440, 15, 29, "Text"],
Cell[47779, 1387, 283, 6, 90, "Input"],
Cell[48065, 1395, 354, 7, 48, "Text"],
Cell[48422, 1404, 58, 1, 50, "Input"],
Cell[48483, 1407, 751, 26, 48, "Text"],
Cell[49237, 1435, 81, 1, 50, "Input"],
Cell[49321, 1438, 201, 8, 29, "Text"],
Cell[49525, 1448, 147, 2, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49709, 1455, 55, 0, 46, "Subsection"],
Cell[49767, 1457, 204, 5, 29, "Text"],
Cell[49974, 1464, 237, 6, 150, "Input"],
Cell[50214, 1472, 153, 5, 29, "Text"],
Cell[50370, 1479, 208, 3, 90, "Input"],
Cell[50581, 1484, 274, 5, 48, "Text"],
Cell[50858, 1491, 79, 2, 70, "Input"],
Cell[50940, 1495, 265, 9, 32, "Text"],
Cell[51208, 1506, 79, 2, 81, "Input"],
Cell[51290, 1510, 68, 2, 81, "Input"],
Cell[51361, 1514, 273, 6, 32, "Text"],
Cell[51637, 1522, 232, 4, 29, "Text"],
Cell[51872, 1528, 343, 9, 48, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52264, 1543, 75, 0, 56, "Section"],
Cell[52342, 1545, 117, 3, 29, "Text"],
Cell[52462, 1550, 117, 2, 50, "Input"],
Cell[52582, 1554, 109, 3, 29, "Text"],
Cell[52694, 1559, 45, 1, 50, "Input"],
Cell[52742, 1562, 204, 8, 29, "Text"],
Cell[52949, 1572, 109, 2, 50, "Input"],
Cell[53061, 1576, 42, 1, 50, "Input"],
Cell[53106, 1579, 186, 3, 90, "Input"],
Cell[53295, 1584, 102, 2, 50, "Input"],
Cell[53400, 1588, 180, 3, 90, "Input"],
Cell[53583, 1593, 279, 7, 29, "Text"],
Cell[53865, 1602, 72, 1, 50, "Input"],
Cell[53940, 1605, 72, 1, 50, "Input"],
Cell[54015, 1608, 231, 5, 29, "Text"],
Cell[54249, 1615, 142, 3, 50, "Input"],
Cell[54394, 1620, 167, 3, 50, "Input"],
Cell[54564, 1625, 312, 7, 48, "Text"],
Cell[54879, 1634, 55, 1, 50, "Input"],
Cell[54937, 1637, 62, 1, 50, "Input"],
Cell[55002, 1640, 162, 3, 51, "Input"],
Cell[55167, 1645, 46, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55250, 1651, 25, 0, 56, "Section"],
Cell[55278, 1653, 413, 9, 48, "Text"],
Cell[55694, 1664, 83, 1, 50, "Input"],
Cell[55780, 1667, 116, 3, 29, "Text"],
Cell[55899, 1672, 996, 18, 246, "Text"],
Cell[56898, 1692, 431, 12, 230, "Input"],
Cell[57332, 1706, 154, 3, 29, "Text"],
Cell[57489, 1711, 356, 6, 90, "Input"],
Cell[57848, 1719, 461, 15, 29, "Text"],
Cell[58312, 1736, 145, 4, 110, "Input"],
Cell[58460, 1742, 107, 3, 29, "Text"],
Cell[58570, 1747, 158, 2, 70, "Input"],
Cell[58731, 1751, 144, 3, 29, "Text"],
Cell[58878, 1756, 137, 2, 50, "Input"],
Cell[59018, 1760, 280, 4, 48, "Text"],
Cell[59301, 1766, 290, 5, 90, "Input"],
Cell[59594, 1773, 182, 4, 29, "Text"],
Cell[59779, 1779, 70, 1, 50, "Input"],
Cell[59852, 1782, 42, 1, 50, "Input"],
Cell[59897, 1785, 38, 0, 29, "Text"],
Cell[59938, 1787, 262, 5, 110, "Input"],
Cell[60203, 1794, 97, 2, 29, "Text"],
Cell[60303, 1798, 57, 1, 50, "Input"],
Cell[60363, 1801, 177, 3, 29, "Text"],
Cell[60543, 1806, 45, 1, 50, "Input"],
Cell[60591, 1809, 48, 1, 50, "Input"],
Cell[60642, 1812, 78, 1, 50, "Input"],
Cell[60723, 1815, 285, 5, 48, "Text"],
Cell[61011, 1822, 483, 9, 150, "Input"],
Cell[61497, 1833, 158, 3, 29, "Text"],
Cell[61658, 1838, 83, 1, 50, "Input"],
Cell[61744, 1841, 371, 9, 48, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62152, 1855, 105, 3, 56, "Section"],
Cell[62260, 1860, 252, 6, 29, "Text"],
Cell[62515, 1868, 175, 4, 110, "Input"],
Cell[62693, 1874, 383, 6, 48, "Text"],
Cell[63079, 1882, 450, 9, 110, "Input"],
Cell[63532, 1893, 376, 8, 48, "Text"],
Cell[63911, 1903, 276, 5, 130, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64224, 1913, 125, 3, 56, "Section"],
Cell[64352, 1918, 173, 3, 29, "Text"],
Cell[64528, 1923, 420, 8, 110, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64985, 1936, 112, 3, 56, "Section"],
Cell[65100, 1941, 124, 3, 29, "Text"],
Cell[65227, 1946, 55, 1, 50, "Input"],
Cell[65285, 1949, 528, 15, 51, "Text"],
Cell[65816, 1966, 80, 1, 50, "Input"],
Cell[65899, 1969, 400, 9, 48, "Text"],
Cell[66302, 1980, 111, 2, 93, "Input"],
Cell[66416, 1984, 84, 1, 29, "Text"],
Cell[66503, 1987, 79, 1, 50, "Input"],
Cell[66585, 1990, 115, 2, 93, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66737, 1997, 75, 0, 56, "Section"],
Cell[66815, 1999, 123, 3, 29, "Text"],
Cell[66941, 2004, 269, 4, 90, "Input"],
Cell[67213, 2010, 219, 4, 29, "Text"],
Cell[67435, 2016, 46, 1, 50, "Input"],
Cell[67484, 2019, 621, 12, 67, "Text"],
Cell[68108, 2033, 217, 4, 70, "Input"],
Cell[68328, 2039, 270, 5, 70, "Input"],
Cell[68601, 2046, 180, 4, 29, "Text"],
Cell[68784, 2052, 432, 8, 130, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69253, 2065, 67, 0, 56, "Section"],
Cell[69323, 2067, 490, 10, 48, "Text"],
Cell[69816, 2079, 108, 2, 70, "Input"],
Cell[69927, 2083, 260, 5, 29, "Text"],
Cell[70190, 2090, 79, 1, 50, "Input"],
Cell[70272, 2093, 315, 5, 48, "Text"],
Cell[70590, 2100, 77, 1, 50, "Input"],
Cell[70670, 2103, 243, 4, 29, "Text"],
Cell[70916, 2109, 99, 2, 50, "Input"],
Cell[71018, 2113, 198, 4, 29, "Text"],
Cell[71219, 2119, 81, 1, 70, "Input"],
Cell[71303, 2122, 100, 2, 70, "Input"],
Cell[71406, 2126, 316, 7, 48, "Text"],
Cell[71725, 2135, 363, 7, 110, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72125, 2147, 83, 1, 56, "Section"],
Cell[72211, 2150, 320, 5, 48, "Text"],
Cell[72534, 2157, 188, 3, 70, "Input"],
Cell[72725, 2162, 138, 3, 29, "Text"],
Cell[72866, 2167, 69, 2, 70, "Input"],
Cell[72938, 2171, 2160, 71, 105, "Text"],
Cell[75101, 2244, 378, 6, 130, "Input"],
Cell[75482, 2252, 84, 1, 50, "Input"],
Cell[75569, 2255, 325, 11, 29, "Text"],
Cell[75897, 2268, 56, 1, 50, "Input"],
Cell[75956, 2271, 272, 7, 29, "Text"],
Cell[76231, 2280, 104, 2, 51, "Input"],
Cell[76338, 2284, 261, 5, 48, "Text"],
Cell[76602, 2291, 108, 2, 51, "Input"],
Cell[76713, 2295, 167, 3, 29, "Text"],
Cell[76883, 2300, 82, 1, 50, "Input"],
Cell[76968, 2303, 253, 6, 29, "Text"],
Cell[77224, 2311, 74, 1, 50, "Input"],
Cell[77301, 2314, 238, 6, 29, "Text"],
Cell[77542, 2322, 90, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77669, 2328, 44, 0, 56, "Section"],
Cell[77716, 2330, 899, 23, 67, "Text"],
Cell[78618, 2355, 293, 6, 110, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78948, 2366, 59, 0, 56, "Section"],
Cell[79010, 2368, 620, 11, 67, "Text"],
Cell[79633, 2381, 1419, 23, 230, "Input"],
Cell[81055, 2406, 54, 1, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[81146, 2412, 34, 0, 54, "ExerciseMain"],
Cell[81183, 2414, 248, 6, 29, "Text"],

Cell[CellGroupData[{
Cell[81456, 2424, 31, 0, 39, "Exercise"],
Cell[81490, 2426, 228, 4, 110, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[81755, 2435, 73, 1, 39, "Exercise"],
Cell[81831, 2438, 564, 17, 86, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82432, 2460, 31, 0, 39, "Exercise"],
Cell[82466, 2462, 434, 10, 83, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82937, 2477, 31, 0, 39, "Exercise"],
Cell[82971, 2479, 749, 13, 129, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83757, 2497, 31, 0, 39, "Exercise"],
Cell[83791, 2499, 379, 7, 75, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84207, 2511, 31, 0, 39, "Exercise"],
Cell[84241, 2513, 427, 15, 29, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84705, 2533, 31, 0, 39, "Exercise"],
Cell[84739, 2535, 117, 3, 29, "ExerciseText"],
Cell[84859, 2540, 138, 2, 70, "Input"],
Cell[85000, 2544, 132, 3, 29, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85169, 2552, 31, 0, 39, "Exercise"],
Cell[85203, 2554, 211, 4, 29, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85451, 2563, 31, 0, 39, "Exercise"],
Cell[85485, 2565, 551, 14, 72, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

